/*
 * $Id: BDB.java,v 1.1 2006/09/13 17:19:12 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.bios;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

import org.logical_paradox.petitbasic.gui.ByteReader;


/**
 * BDBtHgf[^NXD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class BDB {
	public String magicNumber;
	public int majorVersion;
	public int minorVersion;
	public int fontsize = 8;
	public int highDpi;
	public int lowDpi;
	public int fontBoundingBoxWidth;
	public int fontBoundingBoxHeight;
	public int fontBoundingBoxHorizonOffset;
	public int fontBoundingBoxVerticalOffset;
	public int chars;
	
	/** tHgp^[ */
	public HashMap bitmap = new HashMap();

	/** `tHg̃rbg}bvp^[(g[t) */
	public static int[] tofu = null;

	/**
	 * RXgN^D
	 * @param in ̓Xg[
	 * @throws IOException ǂݍ݂Ɏs
	 */
	public BDB(InputStream in) throws IOException {
		load(in);
	}
	/**
	 * tHgt@CǂݍށD
	 * @param in ̓Xg[
	 * @throws IOException ǂݍ݂Ɏs
	 */
	public void load(InputStream in) throws IOException {
		byte[] data = new byte[in.available()];
		// sɂĂ͓͂obt@O邽߁C1oCgǂ񂾂قm
		for(int i = 0; i < data.length; i++) {
			data[i] = (byte)in.read();
		}
		in.close();

		// tHgf[^̓WJ
		parse(data);
	}
	/**
	 * t@Cǂݍ񂾃f[^ɓWJD
	 * @param data f[^
	 */
	public void parse(byte[] data) {
		ByteReader br = new ByteReader(data);

		magicNumber = br.getString(4);
		majorVersion = (int)br.getByte();
		minorVersion = (int)br.getByte();
		fontsize = (int)br.getByte();
		highDpi = (int)br.getByte();
		lowDpi = (int)br.getByte();
		fontBoundingBoxWidth = (int)br.getByte();
		fontBoundingBoxHeight = (int)br.getByte();
		fontBoundingBoxHorizonOffset = (int)br.getByte();
		fontBoundingBoxVerticalOffset = (int)br.getByte();
		chars = br.getInt(4);

		for(int i = 0; i < chars; i++) {
			// rbg}bv̓WJ
			BitmapFont font = new BitmapFont();
			font.startChar = br.getInt(4);
			font.encoding = br.getInt(4);
			font.swidth[0] = br.getInt(4);
			font.swidth[1] = br.getInt(4);
			font.dwidth[0] = br.getInt(4);
			font.dwidth[1] = br.getInt(4);
			font.bbx[0] = br.getInt(4);
			font.bbx[1] = br.getInt(4);
			font.bbx[2] = br.getInt(4);
			font.bbx[3] = br.getInt(4);

			font.pattern = new int[fontsize];
			for(int j = 0; j < font.pattern.length; j++) {
				font.pattern[j] = br.getInt(2);
			}
			bitmap.put("" + font.startChar, font);
		}
	}
	/**
	 * wLN^ɑΉrbg}bvf[^ԂD
	 * rbg}bvf[^`̏ꍇCg[t()ԂD
	 * @param c LN^
	 * @return rbg}bvf[^
	 */
	public int[] getBitmap(char c) {
		BitmapFont bitmapFontPattern = (BitmapFont)bitmap.get("" + (int)c);
		if(bitmapFontPattern == null) {
			System.out.println("tHgp^[[" + c + "]͖`ł");
			return null;
		} else {
			// tHg`Ă
			return bitmapFontPattern.pattern;
		}
	}
	/**
	 * rbg}bvtHgf[^D
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.1 $
	 */
	static class BitmapFont {
		public int startChar;
		public int encoding;
		public int[] swidth = new int[2];
		public int[] dwidth = new int[2];
		public int[] bbx = new int[4];
		public int[] pattern;
		
		/**
		 * RXgN^D
		 */
		public BitmapFont() {
		}
	}
}
