/*
 * $Id: StandardOutput.java,v 1.15 2006/12/25 18:06:19 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.bios;

import java.io.IOException;
import java.io.OutputStream;

import org.logical_paradox.petitbasic.gui.Cursor;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.event.ScrollEvent;
import org.logical_paradox.petitbasic.gui.event.ScrollEventListener;
import org.logical_paradox.petitbasic.gui.hardware.TextVRAM;

/**
 * WóD
 * ̃NXgpāCeLXgVRAMɑ΂ĕo͂邱ƂłD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.15 $
 */
public class StandardOutput extends OutputStream {
	/** eLXgVRAM */
	public final TextVRAM tvram;
	/** ^C */
	public final PetitBasicGuiRuntimeEnv env;
	/** J[\\ */
	public boolean displayCursor = false;
	/** o̓obt@ */
	private StringBuffer outputBuffer = new StringBuffer();
	/** XN[AbvCxgXi[ */
	private ScrollEventListener scrollEventListener;

	/**
	 * RXgN^D
	 * @param tv eLXgVRAM
	 * @param e ^C
	 */
	public StandardOutput(TextVRAM tv, PetitBasicGuiRuntimeEnv e) {
		tvram = tv;
		env = e;
	}
	/**
	 * XN[AbvCxgXi[o^D
	 * @param lsnr XN[AbvCxgXi[
	 */
	public void setScrollUpEventListener(ScrollEventListener lsnr) {
		scrollEventListener = lsnr;
	}
	/**
	 * XN[AbvCxgXi[폜D
	 */
	public void removeScrollUpEventListener() {
		scrollEventListener = null;
	}
	/**
	 * ݂̃J[\ʒu當o͂D
	 * ʏI[܂ŏo͂ꍇ́C̍s̐擪pD
	 * @param msg 
	 */
	public void print(String msg) {
		if(outputBuffer != null && outputBuffer.length() > 0) {
			// o̓obt@ɉꍇ́CAďo͂
			msg = outputBuffer.toString() + msg;
			outputBuffer = new StringBuffer();
		}
		char[] str = msg.toCharArray();

		for(int i = 0; i < str.length; i++) {
			char c = str[i];
			switch(c) {
				// 
				case ASCIICode.UP:
					if(env.cursorYpos > 0) {
						env.cursorYpos--;
					}
					break;
				// 
				case ASCIICode.DW:
					if(env.cursorYpos < env.config.getCharsVerticalMax() -1) {
						env.cursorYpos++;
					}
					break;
				// E
				case ASCIICode.RI:
					if(env.cursorXpos == env.config.getCharsHorizonMax() -1) {
						if(env.cursorYpos < env.config.getCharsVerticalMax() -1) {
							env.cursorXpos = 0;
							env.cursorYpos++;
						}
					} else {
						env.cursorXpos++;
					}
					break;
				// 
				case ASCIICode.LE:
					if(env.cursorXpos == 0) {
						if(env.cursorYpos > 0) {
							env.cursorXpos = env.config.getCharsHorizonMax() -1;
							env.cursorYpos--;
						}
					} else {
						env.cursorXpos--;
					}
					break;
				// HOME
				case ASCIICode.HO:
					env.cursorXpos = 0;
					env.cursorYpos = 0;
					if(env.keyInputDevice.shiftKeyPressed == true) {
						// SHIFT + HOMȄꍇC\Ă镶
						tvram.clear();
						env.clearLineTerminalTable();
						// t@NVL[\ĕ`
						env.screenEditor.displayFunctionKey();
					}
					break;
				// INS
				case ASCIICode.IS:
					procInsert();
					break;
				// DEL
				case ASCIICode.DE:
					procDelete();
					break;
				// BS
				case ASCIICode.BS:
					procBackSpacing();
					break;
				// ENTER
				case ASCIICode.CR:
					env.cursorXpos = 0;
					break;
				case ASCIICode.LF:
					env.lineTerminalTable.set(env.cursorYpos, PetitBasicGuiRuntimeEnv.LINE_TERM_END_OF_LINE);
					env.cursorYpos++;

					// eLXgʂ̃XN[
					if(env.cursorYpos >= env.config.getCharsVerticalMax()) {
						tvram.scrollUp(env.config.functionKeyDisplay);
						// CxgXi[o^ĂꍇCXN[Abvʒm
						if(scrollEventListener != null) {
							scrollEventListener.scrollUp(new ScrollEvent(this));
						}
						env.cursorYpos--;
					}
					break;
				default:
					// 1o
					outputChar(c);
			}
		}
		env.display.repaint(env.config);
	}
	/**
	 * ݂̃J[\ʒu當o͂CsD
	 * ʏI[܂ŏo͂ꍇ́C̍s̐擪pD
	 * @param msg 
	 */
	public void println(String msg) {
		print(msg + "\r\n");
	}
	/**
	 * 1o͂D
	 * ㏑[h̏ꍇC݂̃J[\ʒuɏo͂D
	 * }[h̏ꍇC݂̃J[\ʒuɏo͌C_s̏I[܂ł1炷D
	 * @param c o͂镶
	 */
	public void outputChar(char c) {
		int vx = 0;			// zJ[\XW
		int vy = 0;			// zJ[\YW
		int endx = 0;
		int endy = 0;
		int width = env.config.getCharsHorizonMax();
		int height = env.config.getCharsVerticalMax();
		boolean returnFlg = false;
		boolean scrollup = false;

		if(env.insert) {
			// }[h̏ꍇ - _s̏I[ʒu
			vy = endy = env.getEndYPosOfLogicalLine(env.cursorYpos);
			vx = endx = env.getEndXPosOfLogicalLine(vy);
			if(vy == env.cursorYpos && vx < env.cursorXpos) {
				vx = env.cursorXpos;
			}
		} else {
			// ㏑[h̏ꍇ
			vx = env.cursorXpos;
			vy = env.cursorYpos;
		}
		// J[\Eֈړ
		vx++;

		// zJ[\ʉE[zꍇCs
		if(vx >= width) {
			returnFlg = true;
			vx = 0;
			vy++;
			if(env.insert && vy < height) {
				// }[hʉ𒴂ĂȂꍇ̓XN[_E
				tvram.scrollDown(vy, env.config.functionKeyDisplay);
				if(scrollEventListener != null) {
					// s̒ǉKvƂȂꍇCXN[_E
					scrollEventListener.scrollDown(new ScrollEvent(this, vy));
				}
				// _s̏I[1sg
				env.lineTerminalTable.set(vy -1, PetitBasicGuiRuntimeEnv.LINE_TERM_CONTINUE);
			}
		}
		// zJ[\YWʉ𒴂ꍇ̓XN[Abv
		if(vy >= height) {
			// eLXgʂ̃XN[
			tvram.scrollUp(env.config.functionKeyDisplay);
			// CxgXi[o^ĂꍇCXN[Abvʒm
			if(scrollEventListener != null) {
				scrollEventListener.scrollUp(new ScrollEvent(this));
			}
			vy--;
			scrollup = true;
		}

		// }[h̏ꍇ̓J[\ʒuȍ~SČ1]
		if(env.insert) {
			// ]JnAhX
			int startAddr = env.cursorYpos * width + env.cursorXpos;
			// ]IAhX
			int endAddr = endy * width + endx;
			// 
			int length = endAddr - startAddr +1;
			
			if(length > 0) {
				// ubN]
				int[] data = tvram.vpeek(env.cursorXpos, env.cursorYpos, length);
				tvram.vpoke(env.cursorXpos +1, env.cursorYpos, data);
			}
		}

		// 1o
		tvram.vpoke(env.cursorXpos, env.cursorYpos - (scrollup ? 1 : 0), c);

		// J[\ʒuXV
		if(env.insert) {
			env.cursorXpos++;
			if(env.cursorXpos >= width) {
				// XN[̏͂łɂĂ̂ŕKvȂ
				if(!scrollup) {
					env.cursorYpos++;
				}
				env.cursorXpos = 0;
			} else if(scrollup) {
				env.cursorYpos--;
			}
		} else {
			env.cursorXpos = vx;
			env.cursorYpos = vy;
		}

		// sp
		if(returnFlg) {
			env.lineTerminalTable.set(vy -1, PetitBasicGuiRuntimeEnv.LINE_TERM_CONTINUE);
		}
	}
	/**
	 * }[h̐؂ւsD
	 * }[hINSL[邲ƂON/OFFD
	 */
	public void procInsert() {
		env.insert = env.insert == false;
		// J[\`ύX
		env.cursor.setStyle(env.cursor.getStyle() == Cursor.CS_OVERWRITE ? Cursor.CS_INSERT : Cursor.CS_OVERWRITE);
	}
	/**
	 * obNXy[X̏sD
	 * _s͈͓̔ł̂݁CO̍폜sȂD<br>
	 * ͍s͈͂́C_s͈̔͂Ɍ肳D
	 */
	public void procBackSpacing() {
		// J[\ʒu܂ޘ_s̏I[߂
		int y = env.getEndYPosOfLogicalLine(env.cursorYpos);

		// ړÕJ[\XW
		int beforeXpos = env.cursorXpos;
		// ړÕJ[\YW
		int beforeYpos = env.cursorYpos;

		// 1̍s̃Xe[^X
		Integer i = (Integer)env.lineTerminalTable.get(beforeYpos == 0 ? 0 : beforeYpos-1);
		if(env.cursorXpos > 0) {
			// J[\ֈړ
			env.cursorXpos--;
		} else if(PetitBasicGuiRuntimeEnv.LINE_TERM_CONTINUE.equals(i)) {
			// J[\psɂC擪ʒuɂꍇ͍sړ
			env.cursorXpos = env.config.getCharsHorizonMax() -1;
			env.cursorYpos--;
		} else {
			// J[\s̐擪ŁCspȂꍇDELETE̓
			procDelete();
			return;
		}

		// ȑÕJ[\ʒũAhX
		int startAddr = env.cursorYpos * env.config.getCharsHorizonMax() + env.cursorXpos;
		// _s̏I[ʒũAhX-1
		int endAddr = (y+1) * env.config.getCharsHorizonMax() -2;
		// ]f[^TCY
		int dataLength = endAddr - startAddr;

		// ubN]
		int[] data = tvram.vpeek(beforeXpos, beforeYpos, dataLength);
		tvram.vpoke(env.cursorXpos, env.cursorYpos, data);

		// _s̏I[ɑ΂āC$00
		tvram.vpoke(env.config.getCharsHorizonMax()-1, y, 0);

	}
	/**
	 * ݂̃J[\ʒuȍ~C_s̏I[܂ł폜D
	 */
	public void procDelete() {
		int y = env.cursorYpos;
		// _s̏I[𒲂ׂ
		while(y < env.config.getCharsVerticalMax()) {
			Integer i = (Integer)env.lineTerminalTable.get(y);
			if(PetitBasicGuiRuntimeEnv.LINE_TERM_CONTINUE.equals(i) == false) {
				// spȊȌꍇ͂ōsIĂ
				break;
			}
			y++;
		}

		// ݂̃J[\ʒũAhX+1
		int startAddr = env.cursorYpos * env.config.getCharsHorizonMax() + env.cursorXpos +1;
		// _s̏I[ʒũAhX-1
		int endAddr = (y+1) * env.config.getCharsHorizonMax();
		// ]f[^TCY
		int dataLength = endAddr - startAddr;

		// ubN]
		int[] data = tvram.vpeek(env.cursorXpos +1, env.cursorYpos, dataLength);
		tvram.vpoke(env.cursorXpos, env.cursorYpos, data);

		// _s̏I[ɑ΂āC$00
		tvram.vpoke(env.config.getCharsHorizonMax()-1, y, 0);
	}
	/**
	 * J[\ʒuύXD
	 * @param x XW
	 * @param y YW
	 */
	public void locate(int x, int y) {
	}
	/**
	 * Wo͂ɑ΂1oCgo͂D
	 * @param b f[^
	 * @throws IOException Wo͂ɑ΂鏑݂Ɏs
	 */
	public void write(int b) throws IOException {
		char c = (char)b;
		outputBuffer.append(c);
		if(c == ASCIICode.CR) {
			// sR[hꍇ́Co̓obt@tbV
			print("");
		}
	}
	/**
	 * o̓obt@̓eo͂D
	 */
	public void flush() {
		print("");
	}
}
