/*
 * $Id: Cls.java,v 1.5 2008/09/13 14:22:58 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * CLSD
 * <br><pre>
 * @\FʂD
 * ʁFXe[gg<br>
 * FCLS [<[h>]
 *       [h0: eLXg/OtBbN/XvCg
 *       [h1: eLXĝ
 *       [h2: OtBbN̂
 *       [h3: XvCĝ
 *       [hȗ̓eLXĝݏ 
 * ᕶFCLS
 *@@@ CLS 2
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class Cls implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("CLSsJn");

		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();

		int mode = 1;
		if(token != null && token.getType() == Token.TYPE_LITERAL) {
			mode = OperationUtils.intValue(token, ctx);
		}

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();

		// ʂ
		switch(mode) {
			// eLXgʂ̂
			case 1:
				genv.cursorXpos = 0;
				genv.cursorYpos = 0;
				genv.stdout.tvram.clear();
				genv.clearLineTerminalTable();
				break;
			// OtBbNʂ̂
			case 2:
				genv.vdp.gvram.clear();
				break;
			case 3:
				genv.vdp.spEngine.clear();
				break;
			// eLXg{OtBbNʁ{XvCg
			case 0:
				genv.cursorXpos = 0;
				genv.cursorYpos = 0;
				genv.stdout.tvram.clear();
				genv.clearLineTerminalTable();
				genv.vdp.gvram.clear();
				genv.vdp.spEngine.clear();
				break;
			// s
			default:
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}

		// t@NVL[\ĕ`
		genv.screenEditor.displayFunctionKey();

		ctx.config.log.println("CLSsI");
		
		return null;
	}

}
