/*
 * $Id: FontDL.java,v 1.2 2008/10/19 16:48:45 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * FONT$D
 * <br><pre>
 * @\FLN^p^[`D
 * ʁFVXeϐ<br>
 * FFONT$(<ASCIIR[h>)=<p^[>
 * @@@FONT$=""
 * ᕶFFONT$(65)=CHR$(255)+CHR(0)+CHR$(255)
 * @@@FONT$=""
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class FontDL implements SystemVariable {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// l̎擾͂łȂ
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
	}

	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		int[] params = svc.subscripts;
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();

		if(params == null || params.length != 1) {
			// w肳ĂȂꍇCJX^tHgf[^NAČɖ߂
			genv.stdout.tvram.initFont();
			// eLXgʂ̍ĕ`
			genv.stdout.tvram.refresh();
			
			return;
		}

		if(svc.token.getType() != Token.TYPE_LITERAL || svc.token.getValueType() != Token.VTYPE_STR) {
			// l
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, svc.line.getLineno());
		}

		int asciiCode = params[0];
		int fontHeight = genv.fontDriver.getFontHeight();

		char[] ptn = svc.token.toString().toCharArray();	//ptndata.toCharArray();
		int[] bitmap = new int[fontHeight];
		int limit = bitmap.length < ptn.length ? bitmap.length : ptn.length;
		for(int i = 0; i < limit; i++) {
			bitmap[i] = ptn[i];
		}
		
		// tHgp^[̒`
		genv.stdout.tvram.defineFont((char)asciiCode, bitmap);
		
		// eLXgʂ̍ĕ`
		genv.stdout.tvram.refresh();
	}

}
