/*
 * $Id: InputDL.java,v 1.1 2008/10/08 18:23:46 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.bios.FIFO;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.ExecutionBreakException;

/**
 * INPUT$D
 * <br><pre>
 * @\Fw肵͂̕D
 * ʁF֐<br>
 * FINPUT$(<͕>)
 * ᕶFA$=INPUT$(1)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class InputDL implements BuiltinCommand {

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// ̉
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		if(token == null || token.getType() != Token.TYPE_LITERAL) {
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, line.getLineno());
		}
		
		// 
		int needLength = (int)OperationUtils.castValueType(token, Token.VTYPE_INT, ctx).getIntValue();

		// L[{[hw蕶͂܂ŁCubN
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		FIFO fifo = genv.getKeyInputBuffer();

		StringBuffer sb = new StringBuffer();

		while(sb.length() < needLength) {
			while(fifo.trigger() == false && fifo.hasNext() == false) {
				try {
					Thread.sleep(1);	// rW[[v
				} catch(InterruptedException e) {
					// 
				}
			}
			if(genv.screenEditor.breakFlag) {
				// CTRL+CꂽꍇCvO𒆒f
				throw new ExecutionBreakException();
			}
			// 1荞
			char c = fifo.dequeue();
			sb.append(c);
		}
		
		// ߂l̍쐬
		Token rc = new Token(Token.TYPE_LITERAL);
		rc.setValueType(Token.VTYPE_STR);
		rc.setStrValue(sb.toString());
		
		return rc;
	}

}
