/*
 * $Id: Pset.java,v 1.3 2008/11/23 15:49:05 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.util.ArrayList;
import java.util.List;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.VDP;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * PSETD
 * <br><pre>
 * @\Fw肳ꂽFŃhbgzuD
 * ʁFXe[gg<br>
 * FPSET(<XW>,<YW>),<F>
 * ᕶFPSET(256,128),15
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Pset implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("PSETsJn");

		Expression expr = new Expression(env, ctx, line, true);
		List tokens = new ArrayList();
		while(expr.hasNextToken()) {
			tokens.add(expr.eval());
		}

		if(tokens.size() != 2) {
			// ̐sȂ̂ŁCSyntaxError
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		Token colorToken = null;

		if(
			",".equals("" + line.getNextValidToken()) == false ||
			(colorToken = expr.eval()) == null
		) {
			// ,<color-code>̏łȂꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		tokens.add(colorToken);

		int[] values = new int[3];
		for(int i = 0; i < values.length; i++) {
			Token token = (Token)tokens.get(i);
			if(token.getType() != Token.TYPE_LITERAL) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
			} else {
				values[i] = (int)OperationUtils.castValueType(token, Token.VTYPE_INT, ctx).getIntValue();
			}
		}

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		VDP vdp = genv.vdp;
		int x = values[0];
		int y = values[1];
		int c = values[2];

		// PSET
		vdp.pset(x, y, c, VDP.LOPR_NOP);

		// ÿʒuƐFۑ
		genv.pen.x = x;
		genv.pen.y = y;
		genv.pen.color = c;

		// zʂĕ`悷(ōĕ`悵ȂƁCvOs܂ōĕ`悳Ȃ)
		genv.display.repaint(genv.config);

		ctx.config.log.println("PSETsI");

		return null;
	}
}
