/*
 * $Id: Sound.java,v 1.8 2008/11/08 13:41:51 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import javax.sound.sampled.LineUnavailableException;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;
import org.logical_paradox.petitbasic.sound.SoundDevice;

/**
 * PSG.
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class Sound {
	/** WX^ԍ - g[WX^CH.1 */
	public static final int TONE_REG_1 = 0;
	/** WX^ԍ - g[WX^CH.2 */
	public static final int TONE_REG_2 = 1;
	/** WX^ԍ - g[WX^CH.3 */
	public static final int TONE_REG_3 = 2;
	/** WX^ԍ - mCYWX^ */
	public static final int NOISE_REG = 3;
	/** WX^ԍ - {[WX^CH.1 */
	public static final int VOL_REG_1 = 4;
	/** WX^ԍ - {[WX^CH.2 */
	public static final int VOL_REG_2 = 5;
	/** WX^ԍ - {[WX^CH.3 */
	public static final int VOL_REG_3 = 6;
	/** WX^ԍ - mCY{[WX^ */
	public static final int NOISE_VOL_REG = 7;
	/** WX^ԍ - g`WX^CH.1 */
	public static final int WAVE_REG_1 = 8;
	/** WX^ԍ - g`WX^CH.2 */
	public static final int WAVE_REG_2 = 9;
	/** WX^ԍ - g`WX^CH.3 */
	public static final int WAVE_REG_3 = 10;
	/** WX^ԍ - o̓Rg[WX^CH.1 */
	public static final int OUT_CTL_REG_1 = 11;
	/** WX^ԍ - o̓Rg[WX^CH.2 */
	public static final int OUT_CTL_REG_2 = 12;
	/** WX^ԍ - o̓Rg[WX^CH.3 */
	public static final int OUT_CTL_REG_3 = 13;
	/** WX^ԍ - o̓Rg[WX^ mCY */
	public static final int OUT_CTL_REG_N = 14;

	/** zTEhfoCX */
	public final SoundDevice device;
	/** TEhWX^ */
	private int[] register;

	/**
	 * RXgN^D
	 * @param config RtBO[V
	 * @throws LineUnavailableException TEho̓CgpłȂ
	 */
	public Sound(PetitBasicGuiConfig config) throws LineUnavailableException {
		device = new SoundDevice(44100, 4, config.getPSCI(), true);
		device.setWavePattern(2, SoundDevice.WAVE_NOISE);
		register = new int[15];
	}
	/**
	 * 荞݃V[PXD
	 * ^C}[荞ݏ莞ԂƂɋN邱ƁD
	 * @throws InterruptedException TEhfoCX̊荞ݏɎs
	 */
	public void interrupt() throws InterruptedException {
		device.proc();
	}
	/**
	 * `lԂD
	 * @return `l
	 */
	public int getChannels() {
		return device.getChannels();
	}
	/**
	 * zTEhfoCXLɂ.
	 */
	public void enable() {
		device.enable();
	}
	/**
	 * zTEhfoCX𖳌ɂ.
	 */
	public void disable() {
		device.disable();
	}
	/**
	 * TEhWX^Ƀf[^.
	 * @param r WX^ԍ
	 * @param value l
	 */
	public void setPort(int r, int value) {
		int ch = 0;
		switch(r) {
			// g[WX^
			case TONE_REG_1:
			case TONE_REG_2:
			case TONE_REG_3:
				ch = r;
				device.setDividerRatio(ch, value);
				break;
			// mCYWX^
			case NOISE_REG:
				ch = r;
				device.setDividerRatio(ch, value);
				break;
			// g[{[WX^
			case VOL_REG_1:
			case VOL_REG_2:
			case VOL_REG_3:
				ch = r - VOL_REG_1;
				device.setVolume(ch, value);
				break;
			// mCY{[WX^
			case NOISE_VOL_REG:
				ch = r - VOL_REG_1;
				device.setVolume(ch, value);
				break;
			// g`WX^
			case WAVE_REG_1:
			case WAVE_REG_2:
			case WAVE_REG_3:
				ch = r - WAVE_REG_1;
				device.setWavePattern(ch, value);
				break;
			// o̓Rg[WX^
			case OUT_CTL_REG_1:
			case OUT_CTL_REG_2:
			case OUT_CTL_REG_3:
			case OUT_CTL_REG_N:
				ch = r - OUT_CTL_REG_1;
				if(value == 0) {
					// o͗}
					device.mute(ch);
				} else {
					// o͊Jn
					device.setDividerRatio(ch, register[ch]);
				}
				break;
			// 
			default:
				return;
		}
		register[r] = value;
	}
	/**
	 * TEhWX^̒lǂݍ.
	 * @param r WX^ԍ
	 * @return l
	 */
	public int getPort(int r) {
		return register[r];
	}
}
