/*
 * $Id: SpritePattern.java,v 1.6 2008/08/28 18:45:34 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;

/**
 * XvCgD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class SpritePattern {
	/** XvCg̉TCY */
	public final int width;
	/** XvCg̏cTCY */
	public final int height;
	/** p^[() */
	public String pattern;
	/** RtBO[V */
	public PetitBasicGuiConfig config;
	/** rbg}bvf[^ */
	private int[][] bitmap;

	/**
	 * RXgN^D
	 * @param w 
	 * @param h c
	 * @param c RtBO[V
	 */
	public SpritePattern(int w, int h, PetitBasicGuiConfig c) {
		width = w;
		height = h;
		config = c;
		bitmap = new int[h][w];
	}
	/**
	 * RXgN^D
	 * @param ptn XvCgp^[f[^
	 * @param w 
	 * @param h c
	 */
	public SpritePattern(String ptn, int w, int h) {
		width = w;
		height = h;
		bitmap = new int[h][w];
		define(ptn);
	}
	/**
	 * XvCgp^[`D
	 * @param ptn XvCgp^[f[^
	 */
	public void define(String ptn) {
		pattern = ptn;
		char[] data = ptn.toCharArray();
		int x = 0, y = 0;
		for(int i = 0; y < height && i < data.length; i++) {
			int d = data[i] & 0xff;				// 8bit̂ݗL
			for(int j = 0; j < 8; j++) {
				bitmap[y][x++] = (d & 0x80) != 0 ? 1 : 0;
				d <<= 1;
			}
			if(x >= width) {
				x = 0;
				y++;
			}
		}
	}
	/**
	 * rbg}bvf[^Ԃ.
	 * @return rbg}bvf[^
	 */
	public int[][] getBitmap() {
		return bitmap;
	}
}
