/*
 * $Id: Exp.java,v 1.2 2008/11/24 15:54:03 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Mathpack;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * EXP֐D
 * <br><pre>
 * @\FlCsAnԂD-256n256
 * ʁF֐<br>
 * FEXP(<>)
 * ᕶFE=EXP(3)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Exp implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		// ̌^ϊ
		Token value = OperationUtils.castValueType(token, Token.VTYPE_DBL, ctx);
		Mathpack mathpack = env.config.mathpack;

		// -256`256͈̔͊Ȍꍇ̓I[o[t[Ƃ(vZɎԂ肷邽)
		if(
			mathpack.fp_CMPR(value.getRealValue(), mathpack.doubleValue("256")) > 0 ||
			mathpack.fp_CMPR(mathpack.doubleValue("-256"), value.getRealValue()) > 0
		) {
			throw new BasicLanguageException(ErrorCodeConstant.OVERFLOW, line.getLineno());
		}
		// ߎlvZ
		Real r = mathpack.fp_EXP(value.getRealValue());

		// vZʂ͏ɔ{x
		Token a = new Token(Token.TYPE_LITERAL);
		a.setRealValue(r);
		a.setValueType(Token.VTYPE_DBL);

		return a;
	}
}
