/*
 * $Id: Fix.java,v 1.3 2006/12/10 15:23:06 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * FIX֐D
 * <br><pre>
 * @\FɎw肳ꂽl̐ԂD
 * ʁF֐<br>
 * FFIX(<>)
 * ᕶFA=FIX(-12.99995)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Fix implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("FIX֐sJn");

		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		if(
			token.getValueType() == Token.VTYPE_STR ||
			(token.getValueType() == Token.VTYPE_DEF && env.getDefaultValueType() == Token.VTYPE_STR)
		) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}

		// ʂ͕K^ŕԋpD
		Token answer = new Token(token);

		if(token.getValueType() == Token.VTYPE_INT) {
			// ̏ꍇ͉ϊȂł̂܂ܕԂ
			long value = token.getIntValue();
			answer.setIntValue(value);
		} else {
			// ̏ꍇmathpackʂ
			Real real = ctx.config.mathpack.fp_FIX(token.getRealValue());
			answer.setRealValue(real);
		}

		return answer;
	}

}
