/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Run.java,v 1.4 2008/11/12 18:01:05 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;

/**
 * RUN߁D
 * <br><pre>
 * @\FvOs܂D
 * ʁFR}h<br>
 * FRUN [sԍ]
 * ᕶFRUN
 * @@@RUN 100
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class Run implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("RUNR}hsJn");

		if(line.getLineno() >= 0) {
			// RUN߂̓vOł͎słȂ
			throw new BasicLanguageException(ErrorCodeConstant.CANT_EXECUTE, line.getLineno());
		}

		// ݂̃^CێCvO̎sJnD
		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();

		int nextno = -1;
		if(token != null) {
			if(token.getType() != Token.TYPE_LITERAL || token.getValueType() == Token.VTYPE_STR) {
				// ԋpꂽg[NC萔łȂ邢͕̏ꍇSyntax error
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
			if(token.getValueType() == Token.VTYPE_INT) {
				// ̏ꍇ
				nextno = (int)token.getIntValue();
			} else {
				nextno = ctx.config.mathpack.fp_INT(token.getRealValue()).intValue();
			}
		} else {
			// vO̐擪sԍsJn
			nextno = env.getProgramStartLineno();
		}
		ctx.config.log.println("[RUN] Jڐsԍ = " + nextno);

		ctx.config.log.println("RUNR}hsI");

		// t[O𔭐āCʂ̍s֋IɑJڂD
		throw new FlowControlException(nextno);
	}
}
