/*
 * $Id: End.java,v 1.4 2008/09/13 14:19:21 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import java.io.IOException;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;

/**
 * ENDD
 * <br><pre>
 * @\FvO̎sICJĂSẴt@CN[YD
 * ʁFXe[gg<br>
 * FEND
 * ᕶFEND
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class End implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// St@CN[Y
		try {
			env.closeAllFiles();
		} catch (IOException e) {
			e.printStackTrace(ctx.config.log);
			throw new BasicLanguageException(ErrorCodeConstant.DEVICE_IO_ERROR, -1);
		}

		// o^ĂvȌI[ֈړ邱ƂɂāCvO~
		BasicCommandLine[] programs = (BasicCommandLine[])env.getProgramList().toArray(new BasicCommandLine[0]);
		BasicCommandLine endline = programs.length == 0 ? line : programs[programs.length -1];
		int runptr = endline.getTokens().length -1;

		// o^ĂvO̍ŏIs̍ŏIʒuֈړ
		throw new FlowControlException(endline.getLineno(), runptr);
	}

}
