/*
 * $Id: For.java,v 1.11 2008/11/24 15:54:03 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import java.util.Stack;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * FORD
 * <br><pre>
 * @\FFORNEXT̊Ԃň͂܂ꂽXe[ggw̉ŌJԂ
 * ʁFXe[gg<br>
 * FFOR <ϐ>=<l> TO <> [STEP <>]
 * ᕶFFOR I=0 TO 9
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.11 $
 */
public class For implements BuiltinCommand {
	/** FOR`TO`STEP`NEXTReLXg */
	public static final String FOR_NEXT_CTX_NAME = "FOR-TO-STEP-NEXT";

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("FORsJn");

		Stack calling = ctx.getCallingStructureContext(FOR_NEXT_CTX_NAME);
		if(calling.size() >= ctx.config.nestLimitForNext) {
			// ȏFOR̃ReLXgJn邱Ƃ͂łȂ([v̉\)
			throw new BasicLanguageException(ErrorCodeConstant.FOR_WITHOUT_NEXT);
		}

		Token loopVariable = null;
		Token loopBegin = null;
		Token loopEnd = null;
		Token loopStep = null;

		Expression expression = new Expression(env, ctx, line, false);

		if(
			(loopVariable = line.getNextValidToken()).getType() != Token.TYPE_VARIABLE ||
			!"=".equals(line.getNextValidToken().toString()) ||
			(loopBegin = expression.eval()).getType() != Token.TYPE_LITERAL ||
			loopBegin.getValueType() == Token.VTYPE_STR ||
			(loopBegin.getValueType() == Token.VTYPE_DEF && env.getDefaultValueType() == Token.VTYPE_STR) ||
			"TO".equals(line.getNextValidToken().toString().trim()) == false ||
			(loopEnd = expression.eval()).getType() != Token.TYPE_LITERAL ||
			loopEnd.getValueType() == Token.VTYPE_STR ||
			(loopEnd.getValueType() == Token.VTYPE_DEF && env.getDefaultValueType() == Token.VTYPE_STR)
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}

		// FOR <variable>=<expression> TO <expression>܂ŉ͍ς
		ForToStepNextContext forContext = new ForToStepNextContext();

		// [vϐ
		loopVariable = new Token(loopVariable);
		loopVariable.setValueType(env.variableTable.getStrictVariableType(loopVariable));
		forContext.loopVariable = loopVariable;
		// [vϐ̌^肷
		forContext.loopValueType = loopVariable.getValueType();

		// [vJnlCIlC͑Sĕϐ̌^ɍ킹
		forContext.loopBegin = OperationUtils.castValueType(loopBegin, forContext.loopValueType, ctx);
		forContext.loopEnd = OperationUtils.castValueType(loopEnd, forContext.loopValueType, ctx);

		// 
		Token token = line.peekNextValidToken();
		if(token != null && "STEP".equals(token.toString())) {
			token = line.getNextValidToken();
			loopStep = expression.eval();
			if(
				loopStep == null || 
				loopStep.getType() != Token.TYPE_LITERAL || 
				loopStep.getValueType() == Token.VTYPE_STR
			) {
				// STEP̌ɃXebvw肳Ȃ
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
		}
		if(loopStep == null) {
			loopStep = new Token(Token.TYPE_LITERAL);
			loopStep.setValueType(forContext.loopValueType);
			switch(forContext.loopValueType) {
				case Token.VTYPE_INT:
					loopStep.setIntValue(1L);
					break;
				case Token.VTYPE_SGL:
					loopStep.setRealValue(ctx.config.mathpack.floatValue("1"));
					break;
				case Token.VTYPE_DBL:
					loopStep.setRealValue(ctx.config.mathpack.doubleValue("1d"));
					break;
			}
		}
		if("0".equals(loopStep.toString())) {
			// 0̏ꍇC[vƂȂ
			throw new BasicLanguageException(ErrorCodeConstant.INFINITE_LOOP_FOUND, line.getLineno());
		}
		forContext.loopStep = loopStep;

		// [vϐ̃ATC
		env.variableTable.assignVariable(ctx, loopVariable, null, forContext.loopBegin);

		// [vJnʒuۑ
		forContext.lineno = line.getLineno();
		forContext.runptr = line.getRunPtr();

		calling.push(forContext);

		ctx.config.log.println("FORsI");

		return null;
	}
}
