/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Goto.java,v 1.4 2007/03/10 14:49:05 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;

/**
 * GOTOD
 * <br><pre>
 * @\FwsɃWv܂D
 * ʁFXe[gg<br>
 * FGOTO <sԍ>
 * ᕶFGOTO 200
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class Goto implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("GOTOsJn");

		// sԍ̕]
		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();

		if(token == null || token.getType() != Token.TYPE_LITERAL || expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		if(token.getType() != Token.TYPE_LITERAL) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}

		int nextno = OperationUtils.intValue(token, ctx);

		ctx.config.log.println("[GOTO] Jڐsԍ = " + nextno);

		ctx.config.log.println("GOTOsI");

		if(env.isProgramExists(nextno)) {
			// t[O𔭐āCʂ̍s֋IɑJڂD
			throw new FlowControlException(nextno);
		} else {
			// wsԍ݂͑Ȃ
			throw new BasicLanguageException(ErrorCodeConstant.UNDEFINED_LINE_NUMBER, line.getLineno());
		}
	}
}
