/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Lex.java,v 1.9 2007/12/30 12:21:11 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.logical_paradox.petitbasic.Alias;
import org.logical_paradox.petitbasic.PetitBasicConstant;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;
import org.logical_paradox.petitbasic.lex.fsm.data.DataProcessor;
import org.logical_paradox.petitbasic.lex.fsm.number.NumberProcessor;
import org.logical_paradox.petitbasic.lex.fsm.ope.OperatorProcessor;
import org.logical_paradox.petitbasic.lex.fsm.radix.RadixedIntegerProcessor;
import org.logical_paradox.petitbasic.lex.fsm.rw.ReservedWordProcessor;
import org.logical_paradox.petitbasic.lex.fsm.string.StringProcessor;
import org.logical_paradox.petitbasic.lex.scanner.DataScanner;
import org.logical_paradox.petitbasic.lex.scanner.RemarksScanner;
import org.logical_paradox.petitbasic.lex.scanner.Scanner;
import org.logical_paradox.petitbasic.lex.scanner.StandardScanner;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeConfig;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;


/**
 * ͌nD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class Lex {
	/** XLip^[ - W */
	public static final int SCANNER_STD = 0;
	/** XLip^[ - f[^ */
	public static final int SCANNER_DATA = 1;
	/** XLip^[ -  */
	public static final int SCANNER_REMARKS = 2;

	/** BASIC^CRtBO */
	private final BasicRuntimeConfig config;
	/** GCAX */
	private final Alias alias;

	/** XLi */
	private static final Scanner[] scanners = new Scanner[] {
		new StandardScanner(), new DataScanner(), new RemarksScanner()
	};

	/** XLip^[ */
	private int scannerPattern = SCANNER_STD;

	/**
	 * RXgN^D
	 * @param cfg BASIC^CRtBO
	 */
	public Lex(BasicRuntimeConfig cfg) {
		config = cfg;
		alias = Alias.getInstance(PetitBasicConstant.ALIAS_RESOURCE_FILENAME);
	}
	/**
	 * ͂ꂽCɕϊD
	 * @param statement 
	 * @return 
	 * @throws InterpreterException ̓G[
	 */
	public Token[] parse(String statement) throws Exception {
		// 僊Xg
		final List tokenList = new ArrayList();

		// XLip^[
		scannerPattern = SCANNER_STD;

		// ͋Lɕϊ
		Vector list = convertToSymbols(statement);
		int index = 0;
		BasicLanguageException exception = null;
		CharacterSymbol[] symbols = null;
		boolean modify = false;

		while(index < list.size()) {
			int before = index;
			CharacterSymbol next = null;
			String ali = null;
			do {
				next = (CharacterSymbol)list.get(index);
				ali = alias.getRealString("" + next.getCharacter());
				if(ali != null) {
					// ͋L񂪕ύXꂽ̂ŁCăLbV
					replaceAlias(list, index, ali);
					modify = true;
				}
			} while(ali != null);

			String c = "" + next.getCharacter();
			if(symbols == null || modify) {
				symbols = (CharacterSymbol[])list.toArray(new CharacterSymbol[0]);
			}
			modify = false;

			// eXg
			int type = scanners[scannerPattern].test(c);
			AbstractProcessor processor = null;
			Token token = null;

			switch(type) {
				// 萔
				case Scanner.LANG_STRING_LITERAL:
					final StringProcessor fsmString = new StringProcessor("string procesor");
					processor = fsmString;
					fsmString.execute(symbols, index);
					exception = fsmString.getCausedException();
					index = fsmString.getBreakIndex();
					tokenList.add((Token)fsmString.getResult());
					break;

				// Zq
				case Scanner.LANG_OPERATOR:
					final OperatorProcessor fsmOperator = new OperatorProcessor("operator procesor");
					processor = fsmOperator;
					fsmOperator.execute(symbols, index);
					index = fsmOperator.getBreakIndex();
					token = (Token)fsmOperator.getResult();
					if(token != null) {
						tokenList.add(token);
					} else {
						throw new ParseException("Zq̎͂Ɏs", index);
					}
					break;

				// l萔
				case Scanner.LANG_NUMBER_LITERAL:
					final NumberProcessor fsmNumber = new NumberProcessor("number processor", config);
					fsmNumber.execute(symbols, index);
					processor = fsmNumber;
					index = fsmNumber.getBreakIndex();
					tokenList.add((Token)fsmNumber.getResult());
					break;

				// \܂͕ϐ
				case Scanner.LANG_RESERVED_OR_VARNAME:
					final ReservedWordProcessor fsmWord = new ReservedWordProcessor("reserved word processor");
					processor = fsmWord;
					fsmWord.execute(symbols, index);
					index = fsmWord.getBreakIndex();
					Token[] tokens = (Token[])fsmWord.getResult();
					for(int i = 0; i < tokens.length; i++) {
						tokenList.add(tokens[i]);
					}
					break;

				// Rg(c̓͋L͑SăRglƂĎ荞)
				case Scanner.LANG_COMMENT:
					token = new Token(Token.TYPE_COMMENT);
					token.setStrValue(index == list.size()-1 ? "" : getSymbolString(symbols, index+1));
					tokenList.add(token);
					index = list.size();
					break;

				// w萮
				case Scanner.LANG_RADIXED_INT:
					final RadixedIntegerProcessor fsmRadixInteger = new RadixedIntegerProcessor("radix num");
					processor = fsmRadixInteger;
					fsmRadixInteger.execute(symbols, index);
					index = fsmRadixInteger.getBreakIndex();
					tokenList.add((Token)fsmRadixInteger.getResult());
					break;
					
				// 
				case Scanner.LANG_BRACKET:
					token = new Token(Token.TYPE_BRACKET);
					token.setStrValue(c);
					tokenList.add(token);
					index++;
					break;
					
				// f~^
				case Scanner.LANG_DELIMITER:
					token = new Token(Token.TYPE_DELIMITER);
					token.setStrValue(c);
					tokenList.add(token);
					index++;
					scannerPattern = SCANNER_STD;
					break;

				// (󔒂ɕނ̂́CSĔpXy[Xɒu)
				case Scanner.LANG_WHITE_SPC:
					token = new Token(Token.TYPE_CHARACTER);
					token.setStrValue(" ");
					tokenList.add(token);
					index++;
					break;
					
				// sLꍇ͂ŏI
				case Scanner.LANG_ENDMARK:
					index = list.size();
					break;
					
				// f[^
				case Scanner.LANG_DATA:
					final DataProcessor fsmData = new DataProcessor("data processor");
					processor = fsmData;
					fsmData.execute(symbols, index);
					exception = fsmData.getCausedException();
					index = fsmData.getBreakIndex();
					tokenList.add((Token)fsmData.getResult());
					break;

				default:
					// ̑̃LN^́Ĉ܂܏o
					token = new Token(Token.TYPE_CHARACTER);
					token.setStrValue(c);
					tokenList.add(token);
					index++;
					break;
			}

			if(processor != null) {
				exception = processor.getCausedException();
				if(exception != null) {
					throw exception;
				}
	
				if(processor.isScannerChanged()) {
					// 傪󗝂ꂽƂŁCXLiύXꂽ
					scannerPattern = processor.getScannerPattern();
				}
			}

			if(before >= index) {
				throw new IllegalArgumentException(
					"[vo܂: len = " + symbols.length + ", index = " + index + ", char = " + symbols[index].getCharacter()
				);
			}
		}

		return (Token[])tokenList.toArray(new Token[0]);
	}
	/**
	 * ͋LɕϊD
	 * @param msg 
	 * @return ͋L
	 */
	protected Vector convertToSymbols(String msg) {
		char[] chars = msg.toCharArray();
		Vector symbols = new Vector();

		for(int i = 0; i < chars.length; i++) {
			symbols.add(new CharacterSymbol(chars[i]));
		}

		return symbols;
	}
	/**
	 * Xg̎wʒuɓ͋LD
	 * @param symbols L
	 * @param index CfbNX
	 * @param str 
	 */
	protected void replaceAlias(Vector symbols, int index, String str) {
		// ݈ʒu̕폜
		symbols.remove(index);

		// GCAX}
		char[] chars = str.toCharArray();
		for(int i = chars.length-1; i >= 0 ; i--) {
			CharacterSymbol symbol = new CharacterSymbol(chars[i]);
			symbols.insertElementAt(symbol, index);
		}
	}
	/**
	 * wʒuȍ~̓͋L𕶎ƂĘAĕԂD
	 * @param symbols ͋L
	 * @param index CfbNX
	 * @return Aꂽ
	 */
	protected String getSymbolString(CharacterSymbol[] symbols, int index) {
		StringBuffer sb = new StringBuffer();
		for(int i = index; i <  symbols.length; i++) {
			sb.append(symbols[i].getCharacter());
		}
		return sb.toString();
	}
}
