/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: SyntaxConstant.java,v 1.5 2008/09/28 15:29:04 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex;

/**
 * \萔D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public interface SyntaxConstant {
	/** \vf - f~^ */
	public static final String C_DELIM = ":";
	/** \vf - L */
	public static final String C_ASGN_OPR = "=";
	/** \vf - () */
	public static final char C_BRACKET_LEFT = '(';
	/** \vf - (E) */
	public static final String C_BRACKET_RIGHT = ")";

	/** ϐ^ - Px^ */
	public static final char C_VTYPE_SGL = '!';
	/** ϐ^ - {x^ */
	public static final char C_VTYPE_DBL = '#';
	/** ϐ^ - ^ */
	public static final char C_VTYPE_STR = '$';
	/** ϐ^ - ^ */
	public static final char C_VTYPE_INT = '%';

	/** Zq̍ő` */
	public static final int MAX_DEF_OPERATORS = 32;
	/** Zq - ׂ */
	public static final String S_OPR_POW = "^";
	/** Zq - Z */
	public static final String S_OPR_PLS = "+";
	/** Zq - Z */
	public static final String S_OPR_MNS = "-";
	/** Zq - Z */
	public static final String S_OPR_DIV = "/";
	/** Zq - Z */
	public static final String S_OPR_MUL = "*";
	/** Zq - Z */
	public static final String S_OPR_DVI = "\\";
	/** Zq - ֐ */
	public static final String S_OPR_FNC = "[function]";
	/** Zq - }CiX */
	public static final String S_OPR_MSN = "--";
	/** Zq - vX */
	public static final String S_OPR_PSN = "++";
	/** Zq - ]Z */
	public static final String S_OPR_MOD = "MOD";
	/** ֌WZq -  */
	public static final String S_ROPR_EQ = "=";
	/** ֌WZq -  */
	public static final String S_ROPR_LT = "<";
	/** ֌WZq -  */
	public static final String S_ROPR_GT = ">";
	/** ֌WZq -  */
	public static final String S_ROPR_LE = "<=";
	/** ֌WZq -  */
	public static final String S_ROPR_GE = ">=";
	/** ֌WZq -  */
	public static final String S_ROPR_NE = "<>";
	/** _Zq - _ے */
	public static final String S_LOPR_NOT = "NOT";
	/** _Zq - _ */
	public static final String S_LOPR_AND = "AND";
	/** _Zq - _a */
	public static final String S_LOPR_OR = "OR";
	/** _Zq - rI_a */
	public static final String S_LOPR_XOR = "XOR";
	/** _Zq - _ */
	public static final String S_LOPR_IMP = "IMP";
	/** _Zq - _l */
	public static final String S_LOPR_EQV = "EQV";

	/** Zq̗D揇 - ֐ */
	public static final int OPR_FUNC = 1;
	/** Zq̗D揇 - vX */
	public static final int OPR_P_SIGN = 2;
	/** Zq̗D揇 - }CiX */
	public static final int OPR_M_SIGN = 2;
	/** Zq̗D揇 - ׂ */
	public static final int OPR_POW = 3;
	/** Zq̗D揇 - Z */
	public static final int OPR_MUL = 4;
	/** Zq̗D揇 - Z */
	public static final int OPR_DIV = 4;
	/** Zq̗D揇 - Z */
	public static final int OPR_DIVI = 5;
	/** Zq̗D揇 - ]Z */
	public static final int OPR_MOD = 5;
	/** Zq̗D揇 - Z */
	public static final int OPR_PLUS = 6;
	/** Zq̗D揇 - Z */
	public static final int OPR_MINUS = 6;
	/** ֌WZq̗D揇 -  */
	public static final int ROPR_EQ = 7;
	/** ֌WZq̗D揇 -  */
	public static final int ROPR_LT = 7;
	/** ֌WZq̗D揇 -  */
	public static final int ROPR_GT = 7;
	/** ֌WZq̗D揇 -  */
	public static final int ROPR_GE = 7;
	/** ֌WZq̗D揇 -  */
	public static final int ROPR_LE = 7;
	/** ֌WZq̗D揇 -  */
	public static final int ROPR_NE = 7;
	/** Zq̗D揇 - _ے */
	public static final int LOPR_NOT = 8;
	/** Zq̗D揇 - _ */
	public static final int LOPR_AND = 9;
	/** Zq̗D揇 - _a */
	public static final int LOPR_OR = 10;
	/** Zq̗D揇 - rI_a */
	public static final int LOPR_XOR = 11;
	/** Zq̗D揇 - _ */
	public static final int LOPR_IMP = 12;
	/** Zq̗D揇 - _l */
	public static final int LOPR_EQV = 13;
}
