/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RadixedIntegerProcessor.java,v 1.2 2006/10/21 08:55:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm.radix;

import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.common.util.NumberUtils;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * 2/8/16i\L̐l萔邽߂̗LԑJڋ@BD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class RadixedIntegerProcessor extends AbstractProcessor {
	/** 荞ݗp̃obt@ */
	private StringBuffer sb = new StringBuffer();
	/** ǂݎ */
	private IntegerState state = IntegerState.INITIAL;
	/** ^Cv */
	private int radix = -1;

	/**
	 * RXgN^D
	 * @param name ʎq
	 * @throws Exception CX^XɎs
	 */
	public RadixedIntegerProcessor(String name) throws Exception {
		super(name);
	}
	/**
	 * ԑJڋ@Bɑ΂āC͋LǉD
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(state == IntegerState.FINISH || state == IntegerState.ERROR) {
			// ɏIԂȂ̂ŉȂ
			return;
		}
		CharacterSymbol cs = (CharacterSymbol)symbol;
		char c = Character.toUpperCase(cs.getCharacter());

		switch(c) {
			// w\LJn
			case '&':
				if(state != IntegerState.INITIAL) {
					state = IntegerState.FINISH;
				} else {
					state = IntegerState.RADIX_SCANNING;
				}
				break;
			// 2i
			case 'B':
				if(state == IntegerState.RADIX_SCANNING) {
					state = IntegerState.BINARY_SCANNING;
					radix = Token.DF_BIN;
				} else if(state == IntegerState.HEX_SCANNING) {
					sb.append(c);
				} else {
					state = IntegerState.FINISH;
					rollback();
				}
				break;
			// 16i
			case 'H':
				if(state != IntegerState.RADIX_SCANNING) {
					state = IntegerState.FINISH;
					rollback();
				} else {
					state = IntegerState.HEX_SCANNING;
					radix = Token.DF_HEX;
				}
				break;
			// 8i
			case 'O':
				if(state != IntegerState.RADIX_SCANNING) {
					state = IntegerState.FINISH;
					rollback();
				} else {
					state = IntegerState.OCTAL_SCANNING;
					radix = Token.DF_OCT;
				}
				break;

			case '0':
			case '1':
				if(
					state != IntegerState.BINARY_SCANNING &&
					state != IntegerState.OCTAL_SCANNING &&
					state != IntegerState.HEX_SCANNING
				) {
					state = IntegerState.FINISH;
					rollback();
				} else {
					sb.append(c);
				}
				break;

			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				if(state != IntegerState.OCTAL_SCANNING && state != IntegerState.HEX_SCANNING) {
					state = IntegerState.FINISH;
					rollback();
				} else {
					sb.append(c);
				}
				break;

			case '8':
			case '9':
			case 'A':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
				if(state != IntegerState.HEX_SCANNING) {
					state = IntegerState.FINISH;
					rollback();
				} else {
					sb.append(c);
				}
				break;
			// ̑
			default:
				if(state == IntegerState.INITIAL || state == IntegerState.RADIX_SCANNING) {
					// Ԃ܂͊ʒ̏ꍇ́C\G[Ƃ
					setCausedException(new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1));
				} else {
					state = IntegerState.FINISH;
					rollback();
				}
				state = IntegerState.FINISH;
				break;
		}
	}
	/**
	 * IԂ𔻒肷D
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return state == IntegerState.FINISH || state == IntegerState.ERROR;
	}
	/**
	 * ԑJڋ@BXLf[^ԂD
	 * e(valuetype=)̃g[NԂD
	 * @return XLꂽf[^
	 */
	public Object getResult() {
		Token token = new Token(Token.TYPE_LITERAL);
		token.setDecimalFormat(radix);
		long value = 0L;
		// ɍ킹ĕ𐮐ɕϊ
		switch(radix) {
			case Token.DF_BIN:	value = NumberUtils.binaryStringToIntValue(sb.toString()); break;
			case Token.DF_OCT:	value = NumberUtils.octalStringToIntValue(sb.toString()); break;
			case Token.DF_HEX:	value = NumberUtils.hexStringToIntValue(sb.toString()); break;
			default:
				setCausedException(new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1));
		}
		token.setIntValue(value);
		token.setValueType(Token.VTYPE_INT);

		return token;
	}
	/**
	 * I
	 * @throws Exception ȂO
	 */
	public void finish() throws Exception {
		super.finish();

		if(sb.length() == 0) {
			// ǉ荞߂Ȃꍇ͍\G[Ƃ
			setCausedException(new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1));
		}
	}

}
