/*
 * $Id: DataScanner.java,v 1.1 2007/12/26 16:40:14 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.scanner;

/**
 * DATA\͂XLiD
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class DataScanner implements Scanner {
	/** eXgp^[ -  */
	public static final String TEST_PTN_WHITESPC = "[\t ]";
	/** eXgp^[ - J} */
	public static final String TEST_PTN_COMMA = ",";
	/** eXgp^[ - f~^ */
	public static final String TEST_PTN_DELIMITER = "[;:]";
	/** eXgp^[ - sL */
	public static final String TEST_PTN_ENDMARK = "[\\r\\n]";

	/** eXgp^[ */
	private static final TestPattern[] testPatterns = new TestPattern[] {
		new TestPattern(TEST_PTN_WHITESPC, Scanner.LANG_WHITE_SPC),
		new TestPattern(TEST_PTN_COMMA, Scanner.LANG_UNDEFINED),
		new TestPattern(TEST_PTN_DELIMITER, Scanner.LANG_DELIMITER),
		new TestPattern(TEST_PTN_ENDMARK, Scanner.LANG_ENDMARK)
	};

	/**
	 * ͋L].
	 * @param input ͋L
	 * @return ]l
	 */
	public int test(String input) {
		// eXg
		for(int i = 0; i < testPatterns.length; i++) {
			if(input.matches(testPatterns[i].testPattern)) {
				return testPatterns[i].result;
			}
		}

		// ̃p^[ɂvȂꍇ̓f[^
		return Scanner.LANG_DATA;
	}

}
