/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: AdditionOperation.java,v 1.4 2008/06/04 17:32:21 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * ZZqD
 * PƑQZĕԂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class AdditionOperation implements Operation {
	/**
	 * ZsD
	 * @param BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext context, Token v1, Token v2) throws BasicLanguageException {
		Token token = null;
		// vZ͑SĔ{x^ōs
		if(v1.getValueType() == Token.VTYPE_STR || v2.getValueType() == Token.VTYPE_STR) {
			// Ȁꍇ
			if(v1.getValueType() != v2.getValueType()) {
				throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
			}
			token = new Token(v1);
			token.setStrValue(token.getStrValue() + v2.getStrValue());
		} else {
			// l̏ꍇ
			token = new Token(Token.TYPE_LITERAL);
			token.setDecimalFormat(Token.DF_INT);

			if(v1.getValueType() == Token.VTYPE_INT && v2.getValueType() == Token.VTYPE_INT) {
				// m͐ŌvZ
				token.setIntValue(v1.getIntValue() + v2.getIntValue());
				token.setValueType(Token.VTYPE_INT);
			} else {
				// ȂƂЕ̏ꍇC{xŌvZ
				v1 = OperationUtils.castValueType(v1, Token.VTYPE_DBL, context);
				v2 = OperationUtils.castValueType(v2, Token.VTYPE_DBL, context);
				Real answer = context.config.mathpack.fp_ADD(v1.getRealValue(), v2.getRealValue());
				token.setRealValue(answer);
				token.setValueType(Token.VTYPE_DBL);
			}
		}
		return token;
	}

}
