/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ExponentiationOperation.java,v 1.3 2007/03/08 14:54:46 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * wZqD
 * PƑQ悵ĕԂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class ExponentiationOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext ctx, Token v1, Token v2) throws BasicLanguageException {
		if(OperationUtils.isStringValueType(v1.getValueType(), v2.getValueType(), ctx.getDefaultVarType())) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}
		// vZ͑SĔ{x^ōs
		Token d1 = OperationUtils.castValueType(v1, Token.VTYPE_DBL, ctx);
		Token d2 = OperationUtils.castValueType(v2, Token.VTYPE_DBL, ctx);

		Real d3 = ctx.config.mathpack.fp_POW(d1.getRealValue(), d2.getRealValue());
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_DBL);
		token.setRealValue(d3);

		return token;
	}

}
