/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: SubtractionOperation.java,v 1.4 2008/10/19 16:48:09 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * ZZqD
 * PƑQZĕԂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class SubtractionOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext context, Token v1, Token v2) throws BasicLanguageException {
		if(OperationUtils.isStringValueType(v1.getValueType(), v2.getValueType(), context.getDefaultVarType())) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}
		Token token = new Token(Token.TYPE_LITERAL);
		token.setDecimalFormat(Token.DF_INT);

		if(v1.getValueType() == Token.VTYPE_INT && v2.getValueType() == Token.VTYPE_INT) {
			// m͐ŌvZ
			token.setIntValue(v1.getIntValue() - v2.getIntValue());
			token.setValueType(Token.VTYPE_INT);
		} else {
			// ̏ꍇBCDZ
			v1 = OperationUtils.castValueType(v1, Token.VTYPE_DBL, context);
			v2 = OperationUtils.castValueType(v2, Token.VTYPE_DBL, context);

			Real answer = context.config.mathpack.fp_SUB(v1.getRealValue(), v2.getRealValue());
			token.setRealValue(answer);
			token.setValueType(Token.VTYPE_DBL);
		}

		return token;
	}

}
