/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BasicRuntime.java,v 1.34 2009/05/10 13:23:37 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.logical_paradox.common.io.EmptyPrintStream;
import org.logical_paradox.common.util.PropertyUtils;
import org.logical_paradox.petitbasic.Argument;
import org.logical_paradox.petitbasic.ArgumentParser;
import org.logical_paradox.petitbasic.BuiltinCommandLibrary;
import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Lex;
import org.logical_paradox.petitbasic.lex.SyntaxConstant;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.ExecutionBreakException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;
import org.logical_paradox.petitbasic.runtime.exception.NoopException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * BASICsnD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.34 $
 */
public class BasicRuntime {
	/** v`BASIC\[Xt@C */
	public static final String PB_RESOURCE_FILENAME = "petitbasic.properties";

	/** IR[h - Ȃ */
	public static final int EXITC_NO_OPERATION = 0;
	/** IR[h - so^OK */
	public static final int EXITC_ENTRY_LINE = 1;
	/** IR[h - ssOK */
	public static final int EXITC_EXEC_LINE_OK = 10;
	/** IR[h - ssf */
	public static final int EXITC_EXEC_BREAK = 99;

	/** PetitBASIC^Cg */
	private PetitBasicRuntimeExtension runtimeExtension = null;

	/** ͌n */
	private Lex lex;
	/** BASIC^C */
	private final BasicRuntimeEnvironment env;
	/** ^CRtBO[V */
	private final BasicRuntimeConfig config;

	/** BASICvOsɖĂяoCxgXi[ */
	private BasicRuntimeEventListener runtimeListener;

	/**
	 * RXgN^D
	 * @param args vO
	 * @param ps fobOo̓C^[
	 * @throws IOException \[X̓ǂݍ݂Ɏs
	 */
	public BasicRuntime(String[] args, PrintStream ps) throws IOException {
		Properties prop = PropertyUtils.getProperties(PB_RESOURCE_FILENAME);

		// \[Xl̏㏑
		Argument[] arguments = ArgumentParser.parse(args);
		for(int i = 0; i < arguments.length; i++) {
			Argument arg = arguments[i];
			if(arg.isOption()) {
				prop.setProperty(arg.getName(), arg.getValue());
			}
		}
		// RtBO[V̍쐬
		config = new BasicRuntimeConfig(prop);
		config.log = ps == null ? new EmptyPrintStream(null) : ps;

		// ͌n̍쐬
		lex = new Lex(config);

		// BASIC^C쐬
		env = new BasicRuntimeEnvironment(this, config);
		config.log.println("------------ BASIC^CJn܂ ------------");
	}
	/**
	 * PetitBASIC^Cgݒ肷B
	 * @param ext ^Cg
	 */
	public void setBasicRuntimeExtension(PetitBasicRuntimeExtension ext) {
		runtimeExtension = ext;
	}
	/**
	 * BASICߍs1ssD
	 * ̃\bh́C_CNg[hsɃXN[GfB^ȂǂĂяoD
	 * @param o ʏo͐Xg[
	 * @param line ߍs
	 * @return IR[h
	 * @throws BasicLanguageException 炩̃G[
	 */
	public int execute(OutputStream o, String line) throws BasicLanguageException {
		int lineno = -1;
		int rc = EXITC_EXEC_LINE_OK;

		line = line.trim();
		if(line.length() == 0) {
			return EXITC_NO_OPERATION;
		}

		config.log.println("se:[" + line.trim() + "]");

		Pattern lineptn = Pattern.compile("(\\d+)(.+)");
		Matcher linematcher = lineptn.matcher(line);
		Pattern deleptn = Pattern.compile("(\\d+)");
		Matcher delematcher = deleptn.matcher(line);

		if(delematcher.matches() == true) {
			// sԍ݂̂Ȃ̂ŁCws폜
			try {
				lineno = Integer.parseInt(delematcher.group(1).trim());
			} catch(NumberFormatException e) {
				throw new BasicLanguageException(ErrorCodeConstant.OVERFLOW);
			}
			env.removeProgram(lineno);
			// ŏI͍sԍo^
			env.setLastEntryLine(lineno);
			return EXITC_ENTRY_LINE;
		} else if(linematcher.matches() == true) {
			// sԍ擪ɂ̂ŁCvOo^
			try {
				lineno = Integer.parseInt(linematcher.group(1).trim());
			} catch(NumberFormatException e) {
				throw new BasicLanguageException(ErrorCodeConstant.OVERFLOW);
			}
			line = linematcher.group(2).trim();
			if(line.startsWith("*")) {
				// sԍ̎'*'͖
				line = line.substring(1);
			}
			// ŏI͍sԍo^
			env.setLastEntryLine(lineno);
		}
		// R}hs𒆊ԃR[h
		Token[] internalStyleCodes = null;
		try {
			config.log.println("ԃR[h𐶐Ă܂: sԍ[" + lineno + "]");
			internalStyleCodes = lex.parse(line);
		} catch(BasicLanguageException be) {
			// R}hs͒ɁCAs\ȍ\G[oꍇ
			throw be;
		} catch(Exception e){
			// ԃR[h̐ɎsꍇSyntaxError
			config.log.println("ԃR[h̐Ɏs ----");
			e.printStackTrace(config.log);
			throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1);
		}
		BasicCommandLine commandLine = new BasicCommandLine(lineno, internalStyleCodes);

		if(lineno >= 0) {
			// sԍw肳ĂꍇCvOƂēo^
			// ߂ĺuG[Ȃv
			config.log.println("vOo^: sԍ[" + lineno + "]");
			env.registerProgram(lineno, commandLine);
			rc = EXITC_ENTRY_LINE;
		} else {
			// ȊȌꍇ̓_CNgXe[ggƂĎs
			int next = -1;
			int runptr = BasicCommandLine.RUNPTR_BEGIN;
			BasicRuntimeContext ctx = new BasicRuntimeContext(env, config, o);
			boolean cont = true;

			env.running = true;
			try {
				while(cont) {
					cont = false;
					try {
						rc = interpret(ctx, commandLine);
					} catch(FlowControlException e) {
						next = e.getLineno();
						runptr = e.getRunPtr();
						if(runptr != BasicCommandLine.RUNPTR_BEGIN && e.getLineno() == commandLine.getLineno()) {
							cont = true;
							commandLine.setRunPtr(runptr);
						}
					} catch(NoopException noop) {
						return EXITC_NO_OPERATION;
					} catch(ExecutionBreakException e) {
						rc = EXITC_EXEC_BREAK;
						next = -1;
					}
				}

				if(next >= 0) {
					// ̍sԍIɎw肳Ăꍇ(GOTOGOSUB)
					// vO̓rɏ荞܂
					try {
						execute(o, next, runptr);
					} catch(ExecutionBreakException e) {
						rc = EXITC_EXEC_BREAK;
					}
				}
			} catch(RuntimeException re) {
				// ^COꍇCX^bNg[XOɏo͂
				// Internal errorɕϊ
				re.printStackTrace();
				throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1);
			} finally {
				env.running = false;
			}
		}

		return rc;
	}
	/**
	 * o^ĂvO擪sD
	 * @param o ʏo͐Xg[
	 */
	public void execute(OutputStream o) throws BasicLanguageException {
		if(env.countProgramLines() == 0) {
			// vOo^ĂȂ̂ŉȂ
			return;
		}

		// `ςݕϐȂǂSď
		clear();

		// vO̐擪ssJn
		execute(o, env.getProgramStartLineno(), BasicCommandLine.RUNPTR_BEGIN);
	}
	/**
	 * wsvOsD
	 * @param o o̓Xg[
	 * @param lno sJnsԍ
	 * @param runptr vOs̎s|C^
	 */
	public void execute(OutputStream o, int lno, int runptr) throws BasicLanguageException {
		int lineno = lno;
		BasicRuntimeContext ctx = new BasicRuntimeContext(env, config, o);
		ctx.setLineno(lno);

		// ̍sԍT₷邽߂ɁCXgĂ
		ArrayList programList = new ArrayList();
		programList.addAll(env.getProgramList());

		do {
			BasicCommandLine line = (BasicCommandLine)env.getCommandLine(lineno);
			if(line == null) {
				// ws݂Ȃ̂ŃG[Ƃ
				throw new BasicLanguageException(ErrorCodeConstant.UNDEFINED_LINE_NUMBER, lno);	
			} else {
				line.clearRunptr();
				if(runptr != BasicCommandLine.RUNPTR_BEGIN) {
					// vO̓rɊ荞ޏꍇ
					line.setRunPtr(runptr);
				}
				int next = -1;
				runptr = BasicCommandLine.RUNPTR_BEGIN;

				// 1ss
				try {
					int resultCode = interpret(ctx, line);
//					if(resultCode == EXITC_EXEC_BREAK) {
//						throw new ExecutionBreakException();
//					}
				} catch(FlowControlException e) {
					// t[(GOTOCGOSUBCRETURNCIF`THEN`ELSECFORȂ)̃^C~O
					// 1ms̃EFCgD(CPUL邽)
					// CPU莞ԈȏL悤ȃvOɂ́CقƂǂ̏ꍇ[v╪򂪑݂邽
					// ɃEFCg邱ƂŁCvO̎sxɕۂ
					// CPULCƂACfA
					if(!env.nowait) {
						try {
							Thread.sleep(1);
						} catch(InterruptedException ie) {
							// Ȃ
						}
					}
					next = e.getLineno();
					runptr = e.getRunPtr();
					lineno = next;
				} catch(ExecutionBreakException e) {
					// BASICvO̒f - fꂽʒuL^Ă
					env.setLastBrokenLine(lineno);
					env.setLastBrokenRunPtr(line.getRunPtr());
					throw e;
				}

				if(next < 0) {
					// G[ȂŁA̍sԍw肳ĂȂꍇ́A
					int index = programList.indexOf(line);
					if(index < 0 || index == programList.size()-1) {
						// vȌI[Ȃ̂ŏI
						lineno = -1;
					} else {
						BasicCommandLine bcl = (BasicCommandLine)programList.get(index+1);
						lineno = bcl.getLineno();
					}
				}
			}
		} while(lineno >= 0);
	}
	/**
	 * BASICߍssD
	 * @param ctx ^CReLXg
	 * @param line ߍs
	 * @return IR[h
	 * @throws BasicLanguageException BASICƂĉG[ꍇɃX[O
	 */
	protected int interpret(BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		try {
			return interpret(ctx, line, -1);
		} catch(BasicLanguageException e) {
			// G[̏Ԃ^Cɐݒ肷
			env.setLastErrorCausedCode(e.getErrorCode());
			env.setLastErrorCausedLine(line.getLineno());
			
			throw e;
		}
	}
	/**
	 * BASICߍssD
	 * @param ctx ^CReLXg
	 * @param line ߍs
	 * @param runptr s|C^
	 * @return IR[h
	 * @throws BasicLanguageException BASICƂĉG[ꍇɃX[O
	 */
	protected int interpret(BasicRuntimeContext ctx, BasicCommandLine line, int runptr) throws BasicLanguageException {
		Token token = null;

		config.log.println("1ss܂: sԍ[" + line.getLineno() + "]");

		int resultCode = EXITC_EXEC_LINE_OK;

		// sׂ傪ȂȂ邩C邢͍sԍݒ肳ꂽꍇɒf
		int seqno = 1;
		BasicRuntimeEvent runtimeEvent = new BasicRuntimeEvent(ctx, -1);

		if(runptr != BasicCommandLine.RUNPTR_BEGIN) {
			// s|C^w肳ĂꍇC̈ʒusJn
			line.setRunPtr(runptr);
		}

		boolean delim = true;

		while(true) {
			// ^CCxgXi[o^Ă΁CN
			if(runtimeListener != null) {
				runtimeEvent.setLineno(line.getLineno());
				runtimeListener.performEvent(runtimeEvent);
			}

			if(runtimeExtension != null) {
				runtimeExtension.preExecution(ctx,line);
			}

			// ̎擾
			token = line.getNextToken();
			if(token == null) {
				break;
			}
			config.log.println("[" + (seqno++) + "] " + token.getStrValue());

			switch(token.getType()) {
				// \
				case Token.TYPE_RESERVED_WORD:
					// Zqs悤ƂĂꍇ̓G[
					if(delim == false || token.getFuncType() == Token.RTYPE_OPR) {
						throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
					} else if(token.getFuncType() == Token.RTYPE_VAR) {
						// VXeϐ̏ꍇ͕ϐƓƂ
						assignVariable(ctx, token, line);
					} else {
						// ZqȊO̗\ɐϏ
						try {
							BuiltinCommand proc = BuiltinCommandLibrary.getInstance().getCommandOf(token.getStrValue());
							Token rc = proc.execute(env, ctx, line);
						} catch(BasicLanguageException be) {
							if (be.getErrorCode() >= 0) {
								be.setLineno(line.getLineno());
							}
							throw be;
						}
					}
					delim = false;
					break;
				// LN^
				case Token.TYPE_CHARACTER:
					if(" ".equals(token.toString()) == true) {
						// whitespace̓XLbv\Ƃ
						continue;
					} else {
						throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
					}
				// ϐ
				case Token.TYPE_VARIABLE:
					if(delim == false) {
						throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
					}
					assignVariable(ctx, token, line);
					delim = false;
					break;
				// ubN
				case Token.TYPE_BLOCK:
					// s|C^sֈړ
					line.setRunPtr(line.getTokens().length -1);

				// f~^
				case Token.TYPE_DELIMITER:
					delim = true;
					break;
				// Rg
				case Token.TYPE_COMMENT:
					// ĖȂ
					break;
				// ȊO
				default:
					// Syntax errorX[
					throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
		}
		
		return resultCode;
	}
	/**
	 * ϐɒlD
	 * @param ctx ^CReLXg
	 * @param variable ϐ
	 * @param line 
	 * @throws BasicLanguageException 炩̃G[
	 */
	protected void assignVariable(BasicRuntimeContext ctx, Token variable, BasicCommandLine line) throws BasicLanguageException {
		env.config.log.println("ϐւ̑Jn");

		// Y̔
		Token token = line.getNextValidToken();
		int[] subscripts = null;

		if(token != null && "(".equals(token.toString())) {
			// JbȐꍇ͔zȂ̂ŁCs|C^1߂C֐[hŉ͂
			line.rewind();
			subscripts = Expression.getSubscripts(env, ctx, line);

			// zϐ̎̎擾
			token = line.getNextValidToken();
		}
		if(token == null || SyntaxConstant.C_ASGN_OPR.equals(token.getStrValue()) == false || token.getType() != Token.TYPE_OPERATOR) {
			// \̂ŃG[
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		// Eӂ̌vZ
		Expression expression = new Expression(env, ctx, line);
		Token rightExpression = expression.eval();

		if(rightExpression == null) {
			// Eӂ̕]ɎŝSyntax error
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		if(variable.getType() == Token.TYPE_VARIABLE) {
			// ϐATC(ɕϐ̌^m肵Ă)
			variable = new Token(variable);
			variable.setValueType(env.variableTable.getStrictVariableType(variable));
			env.variableTable.assignVariable(ctx, variable, subscripts, rightExpression);
		} else if(variable.getType() == Token.TYPE_RESERVED_WORD && variable.getFuncType() == Token.RTYPE_VAR) {
			// VXeϐɑ΂̏ꍇ
			SystemVariable sysvar = (SystemVariable)BuiltinCommandLibrary.getInstance().getCommandOf(variable.getStrValue());
			if(sysvar == null) {
				config.log.println("VXeϐ[" + variable.toString() + "]`Ă܂");
				throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, line.getLineno());
			}
			// VXeϐɉEӂ̒l
			SystemVariableContext svc = new SystemVariableContext();
			svc.env = env;
			svc.ctx = ctx;
			svc.line = line;
			svc.token = rightExpression;
			svc.subscripts = subscripts;
			sysvar.assign(svc);
		} else {
			// ȊO̓vÕoO
			config.log.println("ϐłVXeϐłȂɑ΂Ēl悤Ƃ܂");
			throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, line.getLineno());
		}
	}
	/**
	 * `ςݕϐȂǂ̊SďD
	 */
	protected void clear() {
		env.clear();
	}
	/**
	 * BASIC^CԂD
	 * @return BASIC^C
	 */
	public BasicRuntimeEnvironment getRuntimeEnvironment() {
		return env;
	}
	/**
	 * BASIC^CRtBOԂD
	 * @return BASIC^CRtBO
	 */
	public BasicRuntimeConfig getRuntimeConfig() {
		return config;
	}
	/**
	 * BASIC̖߂Ɩ߂̍ԂɌĂяoR[obN\bh`D
	 * @param lsnr Xi[
	 */
	public void setRuntimeEventListener(BasicRuntimeEventListener lsnr) {
		runtimeListener = lsnr;
	}
	/**
	 * BASIC̖߂Ɩ߂̍ԂɌĂяoR[obN\bhԂD
	 * @return Xi[
	 */
	public BasicRuntimeEventListener getRuntimeEventListener() {
		return runtimeListener;
	}
}
