/*
 * $Id: NumberParser.java,v 1.4 2007/03/19 14:39:23 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.runtime.mathpack;

/**
 * lp[U[D
 * ̌`ŗ^ꂽl͂ĕԂD<br>
 * ^镶́CɎ͌nɂĕsȕΏĂƂ
 * OɗD
 * @author satoshi akabane@logical-paradox.org
 * @versiop $Revision: 1.4 $
 */
public class NumberParser {
	/**  -  */
	private static final int STATE_INIT = 1;
	/**  - ͒ */
	private static final int STATE_INTEGER = 2;
	/**  - ͒ */
	private static final int STATE_DECIMAL = 3;
	/**  - K\Lǂݎ蒆 */
	private static final int STATE_SIGN = 4;
	/**  - K\Lwǂݎ蒆 */
	private static final int STATE_EXPO = 5;

	/** ͋LW */
	private final char[] symbol;
	/** ͌ʊi[Ώ */
	private final Real real;
	/** l̕(true: / false:) */
	private boolean numSign = true;
	/** w̕(true: / false:) */
	private boolean expoSign = true;
	private int exponent = -1;
	/** ݂̏ */
	private int state = STATE_INIT;

	private StringBuffer intbuf = new StringBuffer();
	private StringBuffer decbuf = new StringBuffer();
	private StringBuffer decpfx = new StringBuffer();
	private StringBuffer expbuf = new StringBuffer();

	/**
	 * RXgN^D
	 * @param real ʊi[
	 * @param value ͂l
	 */
	protected NumberParser(Real r, String value) {
		symbol = value.trim().toCharArray();
		real = r;
	}
	/**
	 * ͏JnD
	 */
	protected void parse() {
		int cnt = 0;
		while(cnt < symbol.length && input(symbol[cnt])) {
			cnt++;
		}

		// ͂ēꂽ̂gāCl肷
		// ̖'0'̓g~O
		String integerPart = intbuf.toString();
		String decimalPart = decbuf.toString();
		String exponentPart = expbuf.toString();
		int specifiedExponent = exponentPart.length() == 0 ? 0 : Integer.parseInt(exponentPart);
		if(expoSign == false) {
			specifiedExponent *= -1;
		}
		// ̒l
		String fraction = integerPart + decimalPart;
		// ̌ꍇ͖Jbg
		if(fraction.length() > real.fraction.length) {
			fraction = fraction.substring(0, real.fraction.length);
		}
		char[] num = fraction.toCharArray();
		int total = 0;
		for(int i = 0; i < num.length; i++) {
			int n = num[i] - '0';
			total += n;
			real.fraction[i] = n;
		}

		// ǑS0ꍇCw̓ftHgl(-1)Ƃ
		if(total == 0) {
			exponent = -1;
			numSign = true;
		}
		real.setFractionOccupied(num.length);

		real.exponent = exponent + specifiedExponent;
		// Zʂ̕
		real.positive = numSign;
	}
	/**
	 * ݂̏Ԃɑ΂1^D
	 * @param c ͋L
	 * @return true: / false:I
	 */
	protected boolean input(char c) {
		switch(state) {
			case STATE_INIT:
				procInit(c);
				break;
			case STATE_INTEGER:
				procInteger(c);
				break;
			case STATE_DECIMAL:
				procDecimal(c);
				break;
			case STATE_SIGN:
				procSign(c);
				break;
			case STATE_EXPO:
				procExpo(c);
				break;
			default:
				throw new IllegalStateException();
		}
		return true;
	}
	/**
	 * Ԃ̏ԑJڊ֐D
	 * @param c ͋L
	 */
	protected void procInit(char c) {
		switch(c) {
			case '+':
				numSign = true;
				state = STATE_INTEGER;
				break;
			case '-':
				numSign = false;
				state = STATE_INTEGER;
				break;
			case '0':
				numSign = true;
				state = STATE_INTEGER;
				break;
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				numSign = true;
				state = STATE_INTEGER;
				intbuf.append(c);
				exponent++;
				break;
			case '.':
				numSign = true;
				state = STATE_DECIMAL;
				break;
			default:
				throw new IllegalStateException();
		}
	}
	/**
	 * ͒Ԃ̏ԑJڊ֐
	 * @param c ͋L
	 * @return true:p / false:G[
	 */
	protected void procInteger(char c) {
		switch(c) {
			case '0':
				if(intbuf.length() == 0) {
					// ̐擪'0'͖
				} else {
					intbuf.append(c);
					exponent++;
				}
				break;
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				intbuf.append(c);
				exponent++;
				break;
			case '.':
				state = STATE_DECIMAL;
				break;
			case 'e':
			case 'E':
				state = STATE_SIGN;
				break;
			default:
				throw new IllegalStateException();
		}
	}
	/**
	 * ͒Ԃ̏ԑJڊ֐
	 * @param c ͋L
	 */
	protected void procDecimal(char c) {
		switch(c) {
			case '0':
				if(intbuf.length() > 0 || decbuf.length() > 0) {
					decpfx.append(c);
				} else {
					exponent--;
				}
				break;
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				int cnt = decbuf.length();
				decbuf.append(decpfx.toString());
				decbuf.append(c);
				if(decpfx.length() > 0) {
					if(exponent < 0 && cnt == 0) {
						exponent -= decpfx.length()-1;
					}
					decpfx = decpfx.delete(0, decpfx.length());
				}
				break;
			case 'e':
			case 'E':
				state = STATE_SIGN;
				break;
			default:
				throw new IllegalStateException();
		}
	}
	/**
	 * K\Lǂݎ蒆Ԃ̏ԑJڊ֐
	 * @param c ͋L
	 */
	protected void procSign(char c) {
		switch(c) {
			case '+':
				state = STATE_EXPO;
				expoSign = true;
				break;
			case '-':
				state = STATE_EXPO;
				expoSign = false;
				break;
			default:
				throw new IllegalStateException();
		}
	}
	/**
	 * K\Lwǂݎ蒆Ԃ̏ԑJڊ֐
	 * @param c ͋L
	 */
	protected void procExpo(char c) {
		switch(c) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				expbuf.append(c);
				break;
			default:
				throw new IllegalStateException();
		}
	}
	/**
	 * ɂ0̘AvD
	 * @param str 
	 * @return A
	 */
	protected int getDecimalExponent(String str) {
		char[] num = str.toCharArray();
		int cnt = 0;
		for(int i = 0; i < num.length; i++) {
			if(num[i] == '0') {
				cnt++;
			} else {
				break;
			}
		}
		return cnt;
	}
}
