/*
 * $Id: DateDL.java,v 1.2 2007/03/10 07:48:33 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.sysvar;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * DATE$D
 * <br><pre>
 * @\FݓtԂD
 * ʁFVXeϐ<br>
 * FDATE$
 * ᕶFA$=DATE$
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class DateDL implements SystemVariable {
	/** ttH[}bg */
	public static final SimpleDateFormat DATE_FORMAT_JPN = new SimpleDateFormat("yyyy/MM/dd");

	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		// ͂łȂ
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, svc.line.getLineno());
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		SimpleDateFormat format = DATE_FORMAT_JPN;
		String ds = null;

		// ݓt̕ϊ
		synchronized(format) {
			ds = format.format(new Timestamp(System.currentTimeMillis()));
		}
		
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_STR);
		token.setStrValue(ds);

		return token;
	}

}
