/*
 * BDF2BDB - BDF font data conveter
 * Release version 0.0.0
 * Copyright (c)2006 satoshi akabane
 * http://www.logical-paradox.org/
 *
 * The MIT License
 * Copyright (c) 2006 satoshi akabane(akabane@logical-paradox.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef __bdf2bdb_h__
#define __bdf2bdb_h__

/* enable debug switch if you need debug information. */
/*#define DEBUG*/


/* size of line buffer */
#define LINEBUFLEN 2048

/* number of tokens per a line */
#define MAX_TOKEN_NUM 1024

/* max bytes of bitmap per a line */
#define MAX_BITMAP_WIDTH_BYTES (2)



/*
 * prototype delarations.
 */
void print_usage();
int execute(const char *bdf_filename, const char *bdb_filename);
void init(void);

/*
 * error code declarations.
 */
#define ERR_NO_ERROR (0)
#define ERR_SYNTAX_ERROR (2)
#define ERR_NO_SUCH_KEYWORD (3)
#define ERR_UNSUPPORTED_VERSION (4)
#define ERR_ILLEGAL_FONT_STATE (5)

/*
 * log levels (don't change this)
 */
#define LOG_ERROR (0)
#define LOG_WARNING (1)
#define LOG_INFO (2)
#define LOG_DEBUG (3)

#endif
