/*
 * BDF2BDB - BDF font data conveter
 * Release version 0.0.0
 * Copyright (c)2006 satoshi akabane
 * http://www.logical-paradox.org/
 *
 * The MIT License
 * Copyright (c) 2006 satoshi akabane(akabane@logical-paradox.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include "bdb.h"
#include "procedures.h"

KEYWORD gs_keyword_mappings[] = {
	/*--- property keywords --*/
	{"STARTFONT", &p_startfont},
	{"COMMENT", &p_comment},
	{"FONT", &p_font},
	{"SIZE", &p_size},
	{"FONTBOUNDINGBOX", &p_fontboundingbox},
	{"STARTPROPERTIES", &p_startproperties},
	{"FONTNAME_REGISTRY", &p_fontname_registry},
	{"FOUNDRY", &p_foundry},
	{"FAMILY_NAME", &p_family_name},
	{"WEIGHT_NAME", &p_weight_name},
	{"SLANT", &p_slant},
	{"SETWIDTH_NAME", &p_setwidth_name},
	{"ADD_STYLE_NAME", &p_add_style_name},
	{"PIXEL_SIZE", &p_pixel_size},
	{"POINT_SIZE", &p_point_size},
	{"RESOLUTION_X", &p_resolution_x},
	{"RESOLUTION_Y", &p_resolution_y},
	{"SPACING", &p_spacing},
	{"AVERAGE_WIDTH", &p_average_width},
	{"CHARSET_REGISTRY", &p_charset_registry},
	{"CHARSET_ENCODING", &p_charset_encoding},
	{"COPYRIGHT", &p_copyright},
	{"DEFAULT_CHAR", &p_default_char},
	{"FONT_ASCENT", &p_font_ascent},
	{"FONT_DESCENT", &p_font_decent},
	{"_XMBDFED_INFO", &p_xmbdfed_info},
	{"ENDPROPERTIES", &p_endproperties},

	/*--- bitmap keywords --*/
	{"CHARS", &p_chars},
	{"STARTCHAR", &p_startchar},
	{"ENCODING", &p_encoding},
	{"SWIDTH", &p_swidth},
	{"DWIDTH", &p_dwidth},
	{"BBX", &p_bbx},
	{"BITMAP", &p_bitmap},
	{"ENDCHAR", &p_endchar},
	{"ENDFONT", &p_endfont},

	/*--- end of keyword definitions --*/
	{(char *)NULL, NULL}
};

/* number of keyword informations */
int gs_number_of_keywords;


/* error message table */
char* gs_error_msg_tbl[] = {
	"",											/* 0 */
	"",											/* 1 */
	"syntax error",								/* 2 */
	"no such keyword",							/* 3 */
	"unsupported format version",				/* 4 */
	"'CHARS' is needed for font desc.'",		/* 5 */

	(char *)NULL
};

int gs_number_of_error_msgs;
