/*
 * $Id: PetitBasicGuiRuntimeEnv.java,v 1.20 2008/08/31 09:03:58 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui;

import java.util.Vector;

import javax.swing.JFrame;

import org.logical_paradox.petitbasic.gui.bios.FIFO;
import org.logical_paradox.petitbasic.gui.bios.FontDriver;
import org.logical_paradox.petitbasic.gui.bios.Pen;
import org.logical_paradox.petitbasic.gui.bios.StandardOutput;
import org.logical_paradox.petitbasic.gui.bios.music.MusicDriver;
import org.logical_paradox.petitbasic.gui.hardware.Display;
import org.logical_paradox.petitbasic.gui.hardware.KeyInputDevice;
import org.logical_paradox.petitbasic.gui.hardware.MouseDevice;
import org.logical_paradox.petitbasic.gui.hardware.Sound;
import org.logical_paradox.petitbasic.gui.hardware.VDP;
import org.logical_paradox.petitbasic.runtime.BasicRuntime;

/**
 * Petit-BASIC GUI^C
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.20 $
 */
public class PetitBasicGuiRuntimeEnv {
	/** ͍s - f[^Ȃ */
	public static final Integer LINE_TERM_NODATA = new Integer(0);
	/** ͍s - sp */
	public static final Integer LINE_TERM_CONTINUE = new Integer(-1);
	/** ͍s - _s̏I[s */
	public static final Integer LINE_TERM_END_OF_LINE = new Integer(1);

	/** L[̓obt@ */
	private final FIFO keyInputBuffer = new FIFO();
	/** L[̓foCX */
	public KeyInputDevice keyInputDevice;
	/** EBhẼ[gt[ */
	public JFrame rootFrame;
	/** }EXfoCX */
	public MouseDevice mouseDevice;
	/** J[\XW(eLXgʏ) */
	public int cursorXpos = 0;
	/** J[\YW(eLXgʏ) */
	public int cursorYpos = 0;
	/** XN[GfB^(true:on / false:off) */
	public boolean editor = true;
	/** }[h(true:on / false:off) */
	public boolean insert = false;
	/** sԍ */
	public boolean autoLineNumber = false;
	/** sԍ */
	public int autoLineNumberStep = 0;
	/** Wo */
	public StandardOutput stdout;
	/** XN[GfB^ */
	public ScreenEditor screenEditor;
	/** BASIC^C */
	public BasicRuntime runtime;
	/** z */
	public Display display;
	/** RtBO[V */
	public final PetitBasicGuiConfig config;
	/** PSG */
	public Sound psg;
	/** ~[WbNhCo */
	public MusicDriver md;
	/** 摜vZbT */
	public VDP vdp;
	/** C^[~ie[u */
	public Vector lineTerminalTable;
	/** J[\ */
	public Cursor cursor;
	/** tHghCo */
	public FontDriver fontDriver;
	/** n[hEFA^C}[l */
	public int timecount = 0;
	/** y */
	public final Pen pen;

	/**
	 * RXgN^D
	 * @param cfg RtBO[V
	 */
	public PetitBasicGuiRuntimeEnv(PetitBasicGuiConfig cfg) {
		config = cfg;
		pen = new Pen(config.getWindowForecolorCode());
		clearLineTerminalTable();
	}
	/**
	 * L[̓obt@ԂD
	 * @return L[̓obt@
	 */
	public FIFO getKeyInputBuffer() {
		return keyInputBuffer;
	}
	/**
	 * C^[~ie[uD
	 */
	public void clearLineTerminalTable() {
		lineTerminalTable = new Vector();
		for(int i = 0; i < config.getCharsVerticalMaxActual(); i++) {
			lineTerminalTable.add(LINE_TERM_NODATA);
		}
	}
	/**
	 * ws̏I[XWԂD
	 * zuĂI[XWԂD
	 * @param y s
	 */
	public int getEndXPosOfLogicalLine(int y) {
		int[] line = stdout.tvram.vpeek(y);
		int x = 0;
		for(x = line.length -1; x > 0; x--) {
			if(line[x] > ' ') {
				break;
			}
		}
		return x;
	}
	/**
	 * ws̘_sI[YWԂD
	 * Wn̓eLXgWnŕԂD
	 * @param y YW
	 * @return I[YW
	 */
	public int getEndYPosOfLogicalLine(int y) {
		// _s̏I[𒲂ׂ
		while(y < config.getCharsVerticalMax()) {
			Integer i = (Integer)lineTerminalTable.get(y);
			if(PetitBasicGuiRuntimeEnv.LINE_TERM_CONTINUE.equals(i) == false) {
				// spȊȌꍇ͂ōsIĂ
				break;
			}
			y++;
		}
		
		return y;
	}
}
