/*
 * $Id: Clipboard.java,v 1.2 2008/12/07 15:34:29 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.bios;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * Nbv{[hD
 * Avbg[Jt@CVXeɉɏ`B
 * @\񋟂D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Clipboard implements ActionListener {
	/** VOgCX^X */
	private static Clipboard instance;
	/** _CAO */
	private JDialog dlg;
	/** Nbv{[h͈ */
	private JTextArea text;
	/** m肳ꂽ */
	private String response = null;
	/** {^ꂽǂ */
	private boolean decide = false;
	/** OK{^ */
	private JButton btnOk;
	/** LZ{^ */
	private JButton btnCancel;

	/**
	 * RXgN^D
	 */
	private Clipboard() {
		init();
	}
	/**
	 * _CAOD
	 */
	private void init() {
		System.out.println("** Nbv{[hĂ܂");

		// AvbgŃ[__CAO̓
		dlg = new JDialog();
		text = new JTextArea();
		JScrollPane scp = new JScrollPane(text);
		
		dlg.setLayout(new BorderLayout());
		JPanel content = new JPanel();
		JPanel control = new JPanel();
		JPanel buttons = new JPanel();
		btnOk = new JButton("OK");
		btnCancel = new JButton("Cancel");
		btnOk.addActionListener(this);
		btnCancel.addActionListener(this);

		buttons.setLayout(new GridLayout(1, 2));
		buttons.add(btnOk);
		buttons.add(btnCancel);

		control.setLayout(new BorderLayout());
		control.add(buttons, BorderLayout.EAST);

		content.setLayout(new GridLayout(1,1));
		content.add(scp);

		dlg.getContentPane().add(content, BorderLayout.CENTER);
		dlg.getContentPane().add(control, BorderLayout.SOUTH);

		dlg.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				close();
			}
		});
		
		System.out.println("** Nbv{[h̏I");
	}
	/**
	 * {^ꂽۂɌĂяoCxgnhD
	 * @param e CxgIuWFNg
	 */
	public void actionPerformed(ActionEvent e) {
		Object o = e.getSource();
		if(o == btnOk) {
			// OK{^
			response = text.getText();
			close();
		} else if(o == btnCancel) {
			// LZ{^
			response = null;
			close();
		}
	}
	/**
	 * _CAON[YD
	 */
	private void close() {
		decide = true;
		// ubN
		System.out.println("** Nbv{[h܂");
		synchronized(this) {
			notify();
		}
		dlg.setVisible(false);
		dlg.dispose();
		
		System.out.println("** Nbv{[h܂");
	}
	/**
	 * _CAO\D
	 * @param title ^Cg
	 * @param msg eLXg
	 */
	private void show(String title, String msg) {
		final int width = 320;
		final int height = 480;
		dlg.setTitle(title);
		dlg.setSize(width, height);
		instance.text.setText(msg);
		Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
		dlg.setLocation(((int)windowLocation.getWidth() - width) /2, ((int)windowLocation.getHeight() - height) /2);
		dlg.setVisible(true);
		decide = false;
	}
	/**
	 * Nbv{[hI[vD
	 * @param title EBhE^Cg
	 * @param str ftHgl
	 * @return ύXꂽNbv{[h̓e
	 */
	public static final String open(String title, String str) {
		if(instance == null) {
			instance = new Clipboard();
		}

		String resp = null;
		try {
			// _CAO̕\
			System.out.println("** Nbv{[h̕\Jn");
			instance.show(title, str);
			System.out.println("** Nbv{[h̕\");

			synchronized(instance) {
				System.out.println("++ ͑҂Jn");
				while(instance.decide == false) {
					System.out.println("++ ͑҂");
					instance.wait();
				}
				System.out.println("++ ͑҂I");
				resp = instance.response;
				
				instance = null;
			}
		} catch(InterruptedException e) {
			// ʂ̃ubNɂ͓ĂȂ͂
			System.err.println("++ 荞݂܂");
		}
		
		return resp;
	}
}
