/*
 * $Id: FontDriver.java,v 1.5 2009/05/10 13:24:41 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.bios;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;



/**
 * tHghCoD
 * BDB`̃tHgGraphicsɑ΂ĕ`悷hCoD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class FontDriver {
	/** tHg - v[ */
	public static final int PLAIN = 1;
	/** tHg -  */
	public static final int BOLD = 2;
	/** tHg -  */
	public static final int UNDERLINE = 4;

	/** rbg}bvtHgf[^ */
	private BDB bdb;
	/** tHAOEhJ[ */
	private Color foreColor = Color.WHITE;
	/** tHgX^C */
	private int fontStyle = PLAIN;
	/** tHgobt@ */
	private Map fontbuf = new HashMap();
	/** tHgJ[ */
	private Map fontcol = new HashMap();

	/**
	 * RXgN^D
	 * @param b BDBrbg}bvtHgf[^
	 */
	private FontDriver(BDB b) {
		bdb = b;
	}
	/**
	 * wtHgɑΉhCo[hD
	 * @param in ̓Xg[
	 * @return 쐬ꂽtHghCo
	 * @throws IOException tHgt@C̃[hɎs
	 */
	public static final FontDriver load(InputStream in) throws IOException {
		BDB bdb = new BDB(in);
		FontDriver fd = new FontDriver(bdb);

		return fd;
	}
	/**
	 * ̃tHghCogpĂtHgf[^̉TCYԂD
	 * @return (P:pixel)Cpx[Xł̕
	 */
	public int getFontWidth() {
		return bdb.fontsize / 2;
	}
	/**
	 * ̃tHghCogpĂtHgf[^̏cTCYԂD
	 * @return c(P:pixel)Cpx[Xł̕
	 */
	public int getFontHeight() {
		return bdb.fontsize;
	}
	/**
	 * tHAOEhJ[ԂD
	 * @return tHAOEhG[
	 */
	public Color getForeColor() {
		return foreColor;
	}
	/**
	 * tHAOEhJ[ݒ肷D
	 * @param color tHAOEhJ[
	 */
	public void setForeColor(Color color) {
		foreColor = color;
	}
	/**
	 * tHgX^CԂD
	 * @return tHgX^C
	 */
	public int getFontStyle() {
		return fontStyle;
	}
	/**
	 * tHgX^Cݒ肷D
	 * @param fs tHgX^C
	 */
	public void setFontStyle(int fs) {
		fontStyle = fs;
	}
	/**
	 * C[Wɑ΂ĕ`悷D
	 * @param bi C[W
	 * @param x `JnʒuXW
	 * @param y `JnʒuYW
	 * @param msg 
	 */
	public void drawString(BufferedImage bi, int x, int y, String msg) {
		drawString(bi, x, y, msg, foreColor, fontStyle);
	}
	/**
	 * C[Wɑ΂ĕ`悷D
	 * @param bi C[W
	 * @param x `JnʒuXW
	 * @param y `JnʒuYW
	 * @param msg 
	 * @param color tHAOEhJ[
	 */
	public void drawString(BufferedImage bi, int x, int y, String msg, Color color) {
		drawString(bi, x, y, msg, color, fontStyle);
	}
	/**
	 * C[Wɑ΂ĕ`悷D
	 * @param bi C[W
	 * @param x `JnʒuXW
	 * @param y `JnʒuYW
	 * @param msg 
	 * @param color tHAOEhJ[
	 * @param style tHgX^C
	 */
	public void drawString(BufferedImage bi, int x, int y, String msg, Color color, int style) {
		char[] str = msg.toCharArray();
		DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
		int[] buf = dbi.getData();
		int width = bi.getWidth();

		for(int i = 0; i < str.length; i++) {
			int foreColor = color.getRGB();
			int bgColor = 0;
			char c = str[i];
			int[] pattern = (int[])fontbuf.get(Character.valueOf(c));
			if(pattern == null) {
				pattern = bdb.getBitmap(str[i]);
			}
			Color[] customColorDef = (Color[])fontcol.get(Character.valueOf(c));
			if(customColorDef != null) {
				foreColor = customColorDef[0].getRGB();
				bgColor = customColorDef[1].getRGB();
			}
			int basey = y;

			if(pattern == null) {
				// YtHgȂꍇ͖
				continue;
			}
			int realFontSize = (str[i] & 0xff00) != 0 ? bdb.fontsize : bdb.fontsize /2;
			for(int j = 0; j < pattern.length; j++) {
				int d = pattern[j];
				for(int k = 0; k < realFontSize; k++) {
					int xx = x + (realFontSize-k-1);
					int yy = basey + j;
					int dd = ((d & (1 << k)) > 0) ? foreColor : bgColor;
					buf[yy * width + xx] = dd;
				}
			}
			x += realFontSize;
		}
	}
	/**
	 * tHgp^[`.
	 * @param c LN^
	 * @param bitmap rbg}bvf[^
	 */
	public void defineFont(char c, int[] bitmap) {
		fontbuf.put(Character.valueOf(c), bitmap);
	}
	/**
	 * tHgƂ̐F`.
	 * @param c LN^
	 * @param foreColor OiF
	 * @param bgColor wiF
	 */
	public void defineColor(char c, Color foreColor, Color bgColor) {
		fontcol.put(Character.valueOf(c), new Color[] { foreColor, bgColor });
	}
	/**
	 * `tHgp^[폜ď.
	 */
	public void initFont() {
		fontbuf.clear();
	}
	/**
	 * `tHgJ[폜ď.
	 */
	public void initFontColor() {
		fontcol.clear();
	}
	/**
	 * `悷D
	 * @param `Ώۗ̈
	 * @param msg 
	 */
	public void drawString(Graphics g, String msg) {
		drawString(g, msg, foreColor, fontStyle);
	}
	/**
	 * `悷D
	 * @param g `Ώۗ̈
	 * @param msg 
	 * @param color tHAOEhJ[
	 */
	public void drawString(Graphics g, String msg, Color color) {
		drawString(g, msg, color, fontStyle);
	}
	/**
	 * `悷D
	 * @param g `Ώۗ̈
	 * @param msg 
	 * @param style tHgX^C
	 */
	public void drawString(Graphics g, String msg, int style) {
		drawString(g, msg, foreColor, style);
	}
	/**
	 * `悷D
	 * @param g `Ώۗ̈
	 * @param msg 
	 * @param color tHAOEhJ[
	 * @param style tHgX^C
	 */
	public void drawString(Graphics g, String msg, Color color, int style) {
		
	}
}
