/*
 * $Id: MMLCompiler.java,v 1.2 2008/11/12 18:01:34 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.bios.music;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.logical_paradox.common.fsm.FiniteStateMachine;
import org.logical_paradox.common.fsm.Symbol;

/**
 * MMLRpCB
 * <pre>
 * T<n>@@@@@e|ݒ肷(32`240)
 * L<n>@@@@@{ݒ肷(1/2/4/8/16/32/64)
 * V<n>@@@@@ʂݒ肷(0`15)
 * O<n>@@@	IN^[uݒ肷(1`7)
 * [A-G][<n>]	
 * R[<n>]@@@@x
 * Q<n>@@@@@(Q[g^C)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 *
 */
public class MMLCompiler {
	/** 1t[̕b */
	private final long frame;
	/**  */
	private static final Map dividerRate;
	/** m[gK}bv */
	private static final Map noteRegulationMap;
	/** ~bt[ϊ̐x */
	private static final int DIVISION_PREC = 3;
	/** ~bt[ϊ臒l */
	private static final long threshold = (long)Math.pow(10,DIVISION_PREC);
	/*
	 * X^eBbNCjVCU
	 */
	static {
		// 쐬
		HashMap dmap = new HashMap();
		// C
		dmap.put("C", new int[]{0xd5d, 0x6af, 0x357, 0x1ac, 0xd6, 0x6b, 0x35, 0x1b});
		// C+
		dmap.put("C+", new int[]{0xc9c, 0x64e, 0x327, 0x194, 0xca, 0x65, 0x32, 0x19});
		// D
		dmap.put("D", new int[]{0xbe7, 0x5f4, 0x2fa, 0x17d, 0xbe, 0x5f, 0x30, 0x18});
		// D+
		dmap.put("D+", new int[]{0xb3c, 0x59e, 0x2cf, 0x168, 0xb4, 0x5a, 0x2d, 0x16});
		// E
		dmap.put("E", new int[]{0xa9b, 0x54e, 0x2a7, 0x153, 0xaa, 0x55, 0x2a, 0x15});
		// F
		dmap.put("F", new int[]{0xa02, 0x501, 0x281, 0x140, 0xa0, 0x50, 0x28, 0x14});
		// F+
		dmap.put("F+", new int[]{0x973, 0x4ba, 0x25d, 0x12e, 0x97, 0x4c, 0x26, 0x13});
		// G
		dmap.put("G", new int[]{0x8eb, 0x476, 0x23b, 0x11d, 0x8f, 0x47, 0x24, 0x12});
		// G+
		dmap.put("G+", new int[]{0x86b, 0x436, 0x21b, 0x10d, 0x87, 0x43, 0x22, 0x11});
		// A
		dmap.put("A", new int[]{0x7f2, 0x3f9, 0x1fd, 0xfe, 0x7f, 0x40, 0x20, 0x10});
		// A+
		dmap.put("A+", new int[]{0x780, 0x3c0, 0x1e0, 0xf0, 0x78, 0x3c, 0x1e, 0x0f});
		// B
		dmap.put("B", new int[]{0x714, 0x38a, 0x1c5, 0xe3, 0x71, 0x39, 0x1c, 0x0e});
		dividerRate = Collections.unmodifiableMap(dmap);

		// m[gK}bv쐬
		HashMap nmap = new HashMap();
		String[][] noteRegulationRules = {
			{"C-" , "C"}, {"D-", "C+"}, {"E-", "D+"}, {"F-", "F"}, {"G-", "F+"},
			{"A-", "G+"}, {"B-", "B"},
			{"E+", "E"}, {"B+", "B"}
		};
		for(int i = 0; i < noteRegulationRules.length; i++) {
			nmap.put(noteRegulationRules[i][0], noteRegulationRules[i][1]);
		}
		noteRegulationMap = Collections.unmodifiableMap(nmap);
	}
	/**
	 * RXgN^B
	 * @param fr 1t[̕b(msec)
	 */
	public MMLCompiler(long fr) {
		frame = fr;
	}
	/**
	 * MMLRpCB
	 * @param mml MML
	 * @return RpCꂽR[h
	 * @throws CompilerException \̓G[Ȃ
	 */
	public ControlCode[] compile(String mml) throws CompilerException {
		char[] chars = mml.trim().toUpperCase().toCharArray();
		CharSymbol[] symbols = new CharSymbol[chars.length];
		for(int i = 0; i < chars.length; i++) {
			symbols[i] = new CharSymbol(chars[i]);
		}

		try {
			// 
			MMLFiniteStateMachine dfa = new MMLFiniteStateMachine("aaa");
			dfa.execute(symbols);
			String[] tokens = (String[])dfa.getResult();
			if(tokens == null) {
				// ̓G[
				throw new CompilerException();
			}

			// RpC
			List codes = new ArrayList();
			long wholeNote = (240 * 1000) / 120;
			long frameOdd = 0L;
			int octave = 4;
			int length = 4;

			for(int i = 0; i < tokens.length; i++) {
				String token = tokens[i];
				char c = token.charAt(0);
				String value = token.substring(1);
				int dotcnt = 0;
				int len = length;
				long remain = 0L;
				long frames = 0L;
				long d = 0L;

				switch(c) {
					// e|ݒ
					case 'T':
						wholeNote = (240 * 1000) / Integer.parseInt(value); break;
					// {ݒ
					case 'L':
						length = Integer.parseInt(value); break;
					// {IN^[uݒ
					case 'O':
						octave = Integer.parseInt(value); break;
					// {ʐݒ
					case 'V':
						codes.add(new ControlCode(ControlCode.VOLUME, Integer.parseInt(value)));
						break;
					// g`ݒ
					case 'W':
						codes.add(new ControlCode(ControlCode.WAVE, Integer.parseInt(value)));
						break;
					// m[g
					case 'C':
					case 'D':
					case 'E':
					case 'F':
					case 'G':
					case 'A':
					case 'B':
						char accidental = ' ';
						if(value.length() > 0) {
							// ՎL̎荞
							char a = value.charAt(0);
							if(a == '+' || a == '#') {
								accidental = '+';
								value = value.substring(1);
							} else if(a == '-') {
								accidental = '-';
								value = value.substring(1);
							}

							// _̘A
							String original = value;
							value = value.replaceAll("\\.", "");
							dotcnt = original.length() - value.length();

							// ̎荞
							if(value.length() > 0) {
								len = Integer.parseInt(value);
							}
						}
						String note = ("" + c + accidental).trim();
						String regulation = (String)noteRegulationMap.get(note);
						note = regulation == null ? note : regulation;
						d = len;
						for(int cnt = 0; cnt < dotcnt+1; cnt++) {
							// [Kv
							remain += wholeNote / d;
							d <<= 1L;
						}
						long freq = ((int[])dividerRate.get("" + c))[octave -1];
						// ~bt[ϊ
						frames = remain / frame + (frameOdd >= threshold ? 1 : 0);
						frameOdd = frameOdd >= threshold ? frameOdd - threshold : frameOdd;
						frameOdd += (remain * threshold / frame) % threshold;
						codes.add(new ControlCode(ControlCode.NOTE, freq, frames));

//						System.out.println("[" + note + "]" + len + "(" +
//								dotcnt + "): " + remain + " msec. / divider rate:" + freq);
						break;
					// x
					case 'R':
						if(value.length() > 0) {
							// ̎荞
							len = Integer.parseInt(value);
						}
						remain = 0L;
						d = len;
						for(int cnt = 0; cnt < dotcnt+1; cnt++) {
							remain += wholeNote / d;
							d <<= 1L;
						}
						// ~bt[ϊ
						frames = remain / frame + (frameOdd >= threshold ? 1 : 0);
						frameOdd = frameOdd >= threshold ? frameOdd - threshold : frameOdd;
						frameOdd += (remain * threshold / frame) % threshold;
						codes.add(new ControlCode(ControlCode.REST, 0, frames));
//						System.out.println("[R]" + len + "(" +
//								dotcnt + "): " + remain + " msec.");
						break;
					default:
						throw new CompilerException();
				}
			}
			
			return (ControlCode[])codes.toArray(new ControlCode[0]);

		} catch (Exception e) {
			e.printStackTrace();
			throw new CompilerException(e);
		}
	}
	/**
	 * we|ł̎w艹荞݃JE^ŉJEgv
	 * @param tempo e|
	 * @param len 
	 * @return JEg
	 */
	protected int calcInterruptCounter(int tempo, int len) {
		return 0;
	}

	public static final void main(String[] args) throws Exception {
		MMLCompiler compiler = new MMLCompiler(10);
		compiler.compile("T120V15O4L8C+4..D.E-F#GABO5CR2");
	}
	/**
	 * MML߂邽߂̌萫LI[g}g
	 * @author satoshi akabane@logical-paradox.org
	 */
	static class MMLFiniteStateMachine extends FiniteStateMachine {
		/** eXgp^[ - T,V,L,O,W */
		private static final String TEST_PTN_TVLOW = "[TVLOW]";
		/** eXgp^[ -  */
		private static final String TEST_PTN_NUMBER = "[0-9]";
		/** eXgp^[ - m[gыx */
		private static final String TEST_PTN_NOTE = "[CDEFGABR]";
		/** eXgp^[ - t_ */
		private static final String TEST_PTN_DOT = "[\\.]";
		/** eXgp^[ - tbgуV[v */
		private static final String TEST_PTN_FS = "[+#-]";

		private static final String[] E = {
			TEST_PTN_TVLOW, TEST_PTN_NUMBER, TEST_PTN_NOTE, TEST_PTN_DOT, TEST_PTN_FS
		};
		/**
		 * ԑJڕ\B
		 * <pre>
		 * z̃CfbNX = ̏(statel)
		 * z̗vf = ̏Ԃ玟̏Ԃւ̑Jڏ
		 * @'-'			: JڂȂ
		 * @p	: Jڂ/󗝂
		 * @Sp	: Jڂ/󗝂
		 * </pre>
		 */
		private static final String[] STT = {
			"1-3--", "-2---", "P2R--", "P4R65", "P4R6-", "P4R6-", "P-R6-"
		};
		/** I */
		private static final int F = 999;

		/** hCoR}hQ */
		private List codes = new ArrayList();
		/**  (q0`q6) */
		private int state = 0;
		/** 荞ݒ̃g[N */
		private StringBuffer fragment = new StringBuffer();
		/**
		 * RXgN^B
		 * @param name ԑJڋ@B
		 * @param fr 1t[̕b
		 * @throws Exception Ɏs
		 */
		public MMLFiniteStateMachine(String name) throws Exception {
			super(name);
		}
		/**
		 * ͌ʂԂB
		 * @return ͌(ControlCode̔z)
		 */
		public Object getResult() {
			if(codes != null && fragment != null && fragment.length() > 0) {
				codes.add(fragment.toString());
				fragment = new StringBuffer();
			}
			return codes == null ? null : codes.toArray(new String[0]);
		}
		/**
		 * V͋LB
		 * @param symbol ͋L
		 */
		protected void input(Symbol symbol) {
			char c = ((CharSymbol)symbol).character;
			String cc = "" + c;

			boolean accept = false;
			for(int i = 0; i < E.length; i++) {
				if(cc.matches(E[i])) {
					char v = STT[state].charAt(i);
					if(v == '-') {
						// Jڕs\
						state = F;
						codes = null;
					} else {
						accept = v >= 'P' && v <= 'X';
						state = accept ? v - 'O' : v - '0';
					}
				}
			}
			if(accept) {
				// 󗝏Ԃ֑JڂꍇC݂܂ł̓eƂĎʂ
				codes.add(fragment.toString());
				fragment = new StringBuffer();
			}
			fragment.append(c);
		}
		/**
		 * DFAǂԂB
		 * @return true:I / false:
		 */
		protected boolean isFiniteState() {
			return state == F;
		}
	}
	/**
	 * ͋LB
	 * @author satoshi akabane@logical-paradox.org
	 */
	class CharSymbol implements Symbol {
		/** LN^ */
		public final char character;
		
		/**
		 * RXgN^B
		 * @param c LN^
		 */
		public CharSymbol(char c) {
			character = c;
		}
	}
}
