/*
 * $Id: Color.java,v 1.6 2009/05/10 13:24:41 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * COLOR߁D
 * <br><pre>
 * @\Fʂ̑OiFEwiFύXD
 * ʁFR}h<br>
 * FCOLOR [<OiF>],[<wiF>]
 * ᕶFCOLOR 15,4
 *@@@ COLOR ,4
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class Color implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, false);
		Token[] tokens = new Token[2];
		
		Token token = null;
		int cnt = 0;
		do {
			token = expr.eval();
			if(token == null) {
				break;
			}
			if(",".equals(token.toString())) {
				line.getNextValidToken();
				cnt++;
			} else {
				tokens[cnt] = token;
			}
		} while(cnt < tokens.length);
		
		Token foreColor = null;
		Token bgColor = null;
		
		if(tokens[0] != null) {
			foreColor = OperationUtils.castValueType(tokens[0], Token.VTYPE_INT, ctx);
		}
		if(tokens[1] != null) {
			bgColor = OperationUtils.castValueType(tokens[1], Token.VTYPE_INT, ctx);
		}
		if(foreColor == null && bgColor == null) {
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}

		PetitBasicGuiConfig config = PetitBasicGuiRuntimeEnvHolder.getEnvironment().config;
		if(foreColor != null) {
			int cc = (int)foreColor.getIntValue();
			if(cc < 0 || cc > 15) {
				// J[R[h͈͊O
				throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
			}
			config.setWindowForecolorCode(cc);
		}
		if(bgColor != null) {
			int cc = (int)bgColor.getIntValue();
			if(cc < 0 || cc > 15) {
				// J[R[h͈͊O
				throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
			}
			config.setWindowBgcolorCode(cc);
		}

		// JX^tHgG[
		PetitBasicGuiRuntimeEnvHolder.getEnvironment().stdout.tvram.initFontColor();

		// eLXgVRAMNA(ĕ`悷邽)
		PetitBasicGuiRuntimeEnvHolder.getEnvironment().stdout.tvram.refresh();

		return null;
	}

}
