/*
 * $Id: Dispspr.java,v 1.1 2007/02/19 16:32:45 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * DISPSPR߁D
 * <br><pre>
 * @\FXvCgʂ̕\𐧌䂷D
 * ʁFR}h<br>
 * FDISPSPR {ON|OFF}
 *       ON : XvCg\
 *       OFF: XvCg\ɂ
 * ᕶFDISPSPR ON
 *@@@ DISPSPR OFF
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Dispspr implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Token token = line.getNextValidToken();
		if(
			token == null ||
			(!"ON".equals(token.toString()) && !"OFF".equals(token.toString()))
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		boolean state = "ON".equals(token.toString());

		// XvCgVRAMɑ΂ĕ\Ԃݒ肷
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		genv.vdp.spEngine.setEnable(state);

		// ʂ̍ĕ`
		genv.display.repaint(genv.config);

		return null;
	}

}
