/*
 * $Id: Fcol.java,v 1.1 2009/05/10 13:24:41 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * FONT$D
 * <br><pre>
 * @\FtHg̐F`D
 * ʁFVXeϐ<br>
 * FFCOL(<ASCIIR[h>)=F(4bit:OiF^4bit:wiF)
 * ᕶFFCOL(ASC("A"))=&HF7
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Fcol implements SystemVariable {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		// l̎擾͂łȂ
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
	}

	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		int[] params = svc.subscripts;
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();

		if(params == null || params.length != 1) {
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, -1);
		}

		if(svc.token.getType() != Token.TYPE_LITERAL || svc.token.getValueType() == Token.VTYPE_STR) {
			// l
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, svc.line.getLineno());
		}

		int asciiCode = params[0];
		int color = (int)OperationUtils.castValueType(svc.token, Token.VTYPE_INT, svc.ctx).getIntValue();
		
		// tHgJ[̒`
		genv.stdout.tvram.defineFontColor((char)asciiCode, (color & 0xf0) >> 4, color & 0x0f);
		
		// eLXgʂ̍ĕ`
		genv.stdout.tvram.refresh();
	}
}
