/*
 * $Id: InkeyDL.java,v 1.2 2009/05/10 13:24:41 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * INKEY$D
 * <br><pre>
 * @\FL[͏Ԃ擾^NAD
 * ʁFVXeϐ<br>
 * FINKEY$
 * @@@INKEY$=""
 * ᕶFA$=INKEY$
 * @@@INKEY$=""
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class InkeyDL implements SystemVariable {
	/**
	 * VXeϐɑ΂ĒlD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		Token token = svc.token;
		
		if(token == null ||token.getType() != Token.TYPE_LITERAL) {
			// Iyhs
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		} else if(token.getValueType() != Token.VTYPE_STR) {
			// ^s
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
		}
		
		// L[̓obt@NA
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		genv.getKeyInputBuffer().clear();
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		char keyPressed = genv.keyInputDevice.getLastPressedKeyChar();
		
		Token rc = new Token(Token.TYPE_LITERAL);
		rc.setValueType(Token.VTYPE_STR);
		String key = "";
		
		if(keyPressed != '\u0000') {
			key = "" + keyPressed;
		}
		rc.setStrValue(key);

		return rc;
	}

}
