/*
 * $Id: Input.java,v 1.7 2008/11/24 15:54:14 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.bios.FIFO;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.ExecutionBreakException;
import org.logical_paradox.petitbasic.var.Variable;

/**
 * INPUTD
 * <br><pre>
 * @\FL[{[h當܂͒l͂D
 * ʁFXe[gg<br>
 * FINPUT [<vvg>;][<ϐ>]
 * ᕶFINPUT "ENTER PASSWORD";PW$
 *@@@ INPUT A
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class Input implements BuiltinCommand {
	/** vvg */
	public static final String PROMPT = "? ";
	/** ē͗vbZ[W */
	public static final String REDO_FROM_START = "?Redo from start";

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("INPUTsJn");
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		String prompt = PROMPT;
		Expression expr = new Expression(env, ctx, line);
	
		Token token = line.getNextValidToken();
		if(token == null) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		if(token.getType() != Token.TYPE_VARIABLE) {
			line.rewind();
			token = expr.eval();
			if(token.getType() == Token.TYPE_LITERAL && token.getValueType() == Token.VTYPE_STR) {
				// 񂪗^ꂽꍇ̓vvgƂ
				prompt = token.toString() + prompt;
				token = line.getNextValidToken();
				if(token == null || !";".equals(token.toString())) {
					// ̕';' + ϐłȂꍇ͍\G[
					throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
				}
				token = line.getNextValidToken();
			}
		}
		
		// ϐłȂꍇ͍\G[
		if(token.getType() != Token.TYPE_VARIABLE) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		// ϐ̎擾
		Variable var = env.variableTable.getVariable(ctx, line, token);
		boolean guard = true;

		while(guard) {
			// vvg̕\
			genv.stdout.print(prompt);
			// J[\\
			genv.screenEditor.show(false);
	
			FIFO fifo = genv.getKeyInputBuffer();
			try {
				String value = genv.screenEditor.input(fifo);
				if(value.startsWith(prompt)) {
					// ͍s̐擪̃vvg폜
					value = value.substring(prompt.length()).trim();
				}
				// ^ϊƕϐl̍XV
				Token valueOfVariable = var.toToken();
				try {
					OperationUtils.setValue(env.config, valueOfVariable, value);
					var.setValue(valueOfVariable);
					guard = false;
				} catch(Exception e) {
					// ϊG[
					genv.stdout.println(REDO_FROM_START);
				}
			} catch (InterruptedException e) {
				// L[{[h͏Ɋ荞݂̂ŃvO𒆎~
				genv.stdout.println("");
				throw new ExecutionBreakException(line.getLineno());
			}
		}
		ctx.config.log.println("INPUTsI");
		return null;
	}

}
