/*
 * $Id: Line.java,v 1.3 2008/03/30 16:53:15 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.VDP;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * LINED
 * <br><pre>
 * @\FOtBbNʂɑ΂āCE``悷D
 * ʁFXe[gg<br>
 * FLINE[[STEP](<JnW>,<JncW>)]-[STEP](<IW>,<IW>)[,<F>][,B[F]][,<_Zq>]
 * ᕶFLINESTEP(-10,10)-STEP(150,10),15,BF,XOR
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Line implements BuiltinCommand {
	public static final String TOKEN_STEP = "STEP";
	public static final int METHOD_LINE = 0;
	public static final int METHOD_BOX = 1;
	public static final int METHOD_BOXFILL = 2;

	public static final String PSTR_MT_BOX = "B";
	public static final String PSTR_MT_BOXFILL = "BF";

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		boolean firstStep = false;
		boolean secondStep = false;
		boolean specifyRelative = false;
		Token temp = null;
		Token tsx = null;
		Token tsy = null;
		Token tdx = null;
		Token tdy = null;
		int sx = -1;
		int sy = -1;
		int dx = -1;
		int dy = -1;
		int color = -1;
		int method = METHOD_LINE;

		temp = line.peekNextValidToken();
		// STEP
		if(temp != null && TOKEN_STEP.equals(temp.toString())) {
			firstStep = true;
			temp = line.getNextValidToken();		// |C^i߂
		} else if(temp != null && "-".equals(temp.toString())) {
			// nCt̏ꍇ
			specifyRelative = true;
		}

		if(specifyRelative == false) {
			// JnX,YW(΍WwłȂꍇ̂݉߂)
			Expression expr = new Expression(env, ctx, line, true);
			if(
				(tsx = expr.eval()) == null ||
				tsx.getType() != Token.TYPE_LITERAL ||
				(tsy = expr.eval()) == null ||
				tsy.getType() != Token.TYPE_LITERAL ||
				expr.hasNextToken() == true
			) {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
		}

		// nCt(\Iɂ͕K{ł)
		if((temp = line.getNextValidToken()) == null || !"-".equals(temp.toString())) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		// STEP
		temp = line.peekNextValidToken();
		if(temp != null && TOKEN_STEP.equals(temp.toString())) {
			secondStep = true;
			temp = line.getNextValidToken();		// |C^i߂
		}

		// IX,YW(\Iɂ͕K{ł)
		Expression expr = new Expression(env, ctx, line, true);
		if(
			(tdx = expr.eval()) == null ||
			tdx.getType() != Token.TYPE_LITERAL ||
			(tdy = expr.eval()) == null ||
			tdy.getType() != Token.TYPE_LITERAL ||
			expr.hasNextToken() == true
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		// IvV̎擾
		boolean loop = true;
		int cnt = 0;
		Token[] options = new Token[3];		// 0:F 1:BF 2:_Zq
		while(loop) {
			temp = line.peekNextValidToken();
			if(temp == null || !",".equals(temp.toString())) {
				// J}Ȃꍇ͂ŏI
				loop = false;
				continue;
			}
			// |C^i߂
			temp = line.getNextValidToken();
			temp = line.peekNextValidToken();
			if(temp != null && !",".equals(temp.toString())) {
				// J}ȊOꍇ
				if(cnt == 0) {
					// Fw肳ĂꍇɂĂ͎Ƃĕ]
					expr = new Expression(env, ctx, line);
					options[cnt] = expr.eval();
				} else {
					options[cnt] = line.getNextValidToken();
				}
			}
			cnt++;
		}

		// F
		if(options[0] != null) {
			color = OperationUtils.intValue(options[0], ctx);
			if(color < 0 || color > 15) {
				throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
			}
		}
		
		// `@
		if(options[1] != null) {
			String opt = options[1].toString().toUpperCase();
			if(PSTR_MT_BOX.equals(opt)) {
				method = METHOD_BOX;		// BOX
			} else if(PSTR_MT_BOXFILL.equals(opt)) {
				method = METHOD_BOXFILL;	// BOX-FILL
			} else {
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
			}
		}
		
		// _Zq
		int lop = VDP.LOPR_NOP;
		if(options[2] != null) {
			String lopr = options[2].toString().toUpperCase().trim();
			lop = VDP.toLogicalOperationCode(lopr);
		}
		
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		if(specifyRelative) {
			sx = genv.pen.x;
			sy = genv.pen.y;
		} else {
			sx = OperationUtils.intValue(tsx, ctx);
			sy = OperationUtils.intValue(tsy, ctx);
		}
		sx += firstStep ? genv.pen.x : 0;
		sy += firstStep ? genv.pen.y : 0;

		dx = OperationUtils.intValue(tdx, ctx);
		dy = OperationUtils.intValue(tdy, ctx);

		if(specifyRelative) {
			// ȌI_̑
			dx += genv.pen.x;
			dy += genv.pen.y;
		} else if(secondStep) {
			// ̎n_̑
			dx += sx;
			dy += sy;
		}
		// VDP̃C`@\N
		// y̐FύX
		if(color >= 0) {
			genv.pen.color = color;
		}
		if(method == METHOD_LINE) {
			// `
			genv.vdp.line(sx, sy, dx, dy, genv.pen.color, lop);
		} else {
			// ``
			genv.vdp.box(sx, sy, dx, dy, genv.pen.color, method == METHOD_BOXFILL, lop);
		}

		// ʂ̍ĕ`
		genv.display.repaint(genv.config);

		// ÿʒuύX
		genv.pen.x = dx;
		genv.pen.y = dy;

		return null;
	}

}
