/*
 * $Id: Load.java,v 1.3 2007/11/11 16:56:45 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.fs.PetitBasicFileSystem;
import org.logical_paradox.petitbasic.gui.bios.Clipboard;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntime;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * LOAD߁D
 * <br><pre>
 * @\FBASICvOǂݍށD
 * ʁFR}h<br>
 * FLOAD <filename>[,R]
 * ᕶFLOAD "sample.bas",R
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Load implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("LOADR}hsJn");

		// sԍ̕]
		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();

		if(token != null) {
			if(
				token.getType() != Token.TYPE_LITERAL ||
				OperationUtils.isStringValueType(token.getValueType(), env.getDefaultValueType()) == false
			) {
				// ȊOꍇ
				throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
			} else if(StringUtils.isEmpty(token.getStrValue().trim())) {
				throw new BasicLanguageException(ErrorCodeConstant.BAD_FILE_NAME, -1);
			}
		}

		PetitBasicFileSystem pbfs = ctx.config.fileSystem;
		byte[] program = null;
		// ǂݍ
		try {
			if(token != null) {
				// COOKIEt@CVXe̓ǂݍ
				String filename = token.getStrValue();
				program = pbfs.load(filename);
			} else {
				// Nbv{[h̓ǂݍ
				String programText = Clipboard.open("vO\tĂ", "");
				if(StringUtils.isEmpty(programText)) {
					// LZꂽC܂͉y[XgȂꍇ͏I
					return null;
				}
				program = programText.getBytes();
			}
			// BASICeLXg̍ĕ]
			BasicRuntime runtime = env.getRuntime();
			// vOXg̏
			runtime.getRuntimeEnvironment().getProgramList().clear();
			StringTokenizer tokenizer = new StringTokenizer(new String(program), "\r\n");
			while(tokenizer.hasMoreTokens()) {
				String ll = tokenizer.nextToken();
				int exitcode = runtime.execute(ctx.getOutputStream(), ll);
				if(exitcode != BasicRuntime.EXITC_ENTRY_LINE) {
					// vO̓o^G[
					throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
				}
			}

		} catch(FileNotFoundException nfe) {
			// t@CȂ
			throw new BasicLanguageException(ErrorCodeConstant.FILE_NOT_FOUND, -1, nfe);
		} catch(IOException ioe) {
			// o̓G[
			throw new BasicLanguageException(ErrorCodeConstant.DISK_IO_ERROR, -1, ioe);
		} catch(Exception e) {
			// G[
			throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1, e);
		}
		ctx.config.log.println("LOADR}hsI");
		return null;
	}
}
