/*
 * $Id: PutSprite.java,v 1.8 2008/11/23 15:49:05 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.SpriteEngine;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * PUTSPRITED
 * <br><pre>
 * @\FXvCg\D
 * ʁFXe[gg
 * FPUTSPRITE <XvCgʔԍ>,(<XW>,<YW>),<XvCgԍ>
 * ᕶFPUTSPRITE 0,(300,240),1
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class PutSprite implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line);
		Token pno = expr.eval();
		Token comma = line.getNextValidToken();
		if(
			pno == null || pno.getType() != Token.TYPE_LITERAL ||
			comma == null || !",".equals(comma.toString())
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		// ֐[hŎN
		expr = new Expression(env, ctx, line, true);
		Token xtoken = null;
		Token ytoken = null;
		Token cc = null;
		Token ptnno = null;

		if(
			!expr.hasNextToken() || (xtoken = expr.eval()) == null || xtoken.getType() != Token.TYPE_LITERAL ||
			!expr.hasNextToken() || (ytoken = expr.eval()) == null || ytoken.getType() != Token.TYPE_LITERAL ||
			expr.hasNextToken() == true ||
			!",".equals(line.getNextValidToken().toString()) ||
			(cc = expr.eval()) == null || cc.getType() != Token.TYPE_LITERAL ||	
//			!",".equals(line.getNextValidToken().toString()) ||
			(ptnno = expr.eval()) == null || ptnno.getType() != Token.TYPE_LITERAL
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		int s = OperationUtils.intValue(pno, ctx);			// XvCgʔԍ
		int x = OperationUtils.intValue(xtoken, ctx);		// XW
		int y = OperationUtils.intValue(ytoken, ctx);		// YW
		int c = OperationUtils.intValue(cc, ctx);			// J[R[h
		int p = OperationUtils.intValue(ptnno, ctx);		// XvCgp^[ԍ

		// ͈̔̓`FbN
		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		if(
			s < 0 || s >= genv.config.getSpriteDispMaxCount() ||
			x < 0 || x >= genv.config.getWindowWidth() ||
			y < 0 || y >= genv.config.getWindowHeight() ||
					 p >= genv.config.getSpriteDeclMaxCount() ||
			c < 0 || c >= genv.config.colorPallet.length
		) {
//			throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
		}

		// XvCg̕ύX
		SpriteEngine spe = genv.vdp.spEngine;
		if(p < 0) {
			spe.setSpriteShown(s, false);
		} else {
			spe.moveSprite(s, x, y, c, p, true);
		}

		// ʍĕ`
		genv.display.repaint(genv.config);

		return null;
	}

}
