/*
 * $Id: Sound.java,v 1.3 2008/11/08 13:41:51 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * SOUND߁D
 * <br><pre>
 * @\FTEhWX^Ƀf[^ށD
 * ʁFR}h<br>
 * FSOUND <WX^ԍ>,<f[^>
 * ᕶFSOUND 0,120
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Sound implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Token rnoToken = null;
		Token commaToken = null;
		Token dataToken = null;
		Expression expr = new Expression(env, ctx, line);
		
		if(
			(rnoToken = expr.eval()) == null ||
			(commaToken = line.getNextValidToken()) == null ||
			(dataToken = expr.eval()) == null ||
			rnoToken.getType() != Token.TYPE_LITERAL ||
			!",".equals(commaToken.toString()) ||
			dataToken.getType() != Token.TYPE_LITERAL
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		int rno = (int)OperationUtils.castValueType(rnoToken, Token.VTYPE_INT, ctx).getIntValue();
		int data = (int)OperationUtils.castValueType(dataToken, Token.VTYPE_INT, ctx).getIntValue();
		
		// zTEhfoCX̃WX^Ƀf[^
		PetitBasicGuiRuntimeEnvHolder.getEnvironment().psg.enable();
		
		try {
			PetitBasicGuiRuntimeEnvHolder.getEnvironment().psg.setPort(rno, data);
		} catch(IllegalArgumentException e) {
			// w肵l͈͊Oꍇ́C͈̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
		}

		return null;
	}

}
