/*
 * $Id: SprMod.java,v 1.1 2008/06/04 17:31:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.hardware.SpriteEngine;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * SPRMODXe[ggD
 * <br><pre>
 * @\FXvCg̃TCYݒ肷D
 * ʁFR}h<br>
 * FSPRMOD <[h>,<XP[Ot@N^>
 *       [h: 0: 8x8
 *       @@@  1: 16x16
 *       @@@  2: 32x32
 *       XP[Ot@N^:
 *       @@@@0: x1
 *       @@@@1: x2
 *       @@@@2: x3
 * ᕶFSPRMOD 1,1
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class SprMod implements BuiltinCommand {
	/** [hϊ}bv */
	private static final Map MODE_CONVERSION_MAP;
	/** XP[ϊ}bv */
	private static final Map SCALE_CONVERSION_MAP;
	
	static {
		// [hϊ}bv
		Map modeMap = new HashMap();
		modeMap.put(new Long(0), new Integer(SpriteEngine.SPRITE_SIZE_8x8));
		modeMap.put(new Long(1), new Integer(SpriteEngine.SPRITE_SIZE_16x16));
		modeMap.put(new Long(2), new Integer(SpriteEngine.SPRITE_SIZE_32x32));
		MODE_CONVERSION_MAP = Collections.unmodifiableMap(modeMap);

		// XP[ϊ}bv
		Map scaleMap = new HashMap();
		scaleMap.put(new Long(0), new Integer(SpriteEngine.SCALING_FACTOR_x1));
		scaleMap.put(new Long(1), new Integer(SpriteEngine.SCALING_FACTOR_x2));
		scaleMap.put(new Long(2), new Integer(SpriteEngine.SCALING_FACTOR_x4));
		SCALE_CONVERSION_MAP = Collections.unmodifiableMap(scaleMap);
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line);
		Token modeToken = null;
		Token scaleToken = null;
		
		if(
			(modeToken = expr.eval()) == null ||
			line.hasMoreTokens() == false ||
			",".equals(line.getNextValidToken().toString()) == false ||
			(scaleToken = expr.eval()) == null
		) {
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}
		
		// ^ɕϊ
		modeToken = OperationUtils.castValueType(modeToken, Token.VTYPE_INT, ctx);
		scaleToken = OperationUtils.castValueType(scaleToken, Token.VTYPE_INT, ctx);

		Integer mode = (Integer)MODE_CONVERSION_MAP.get(new Long(modeToken.getIntValue()));
		Integer scale = (Integer)SCALE_CONVERSION_MAP.get(new Long(scaleToken.getIntValue()));
		
		if(mode == null || scale == null) {
			throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
		}

		PetitBasicGuiRuntimeEnv genv = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		genv.vdp.spEngine.setSpriteMode(mode.intValue());
		genv.vdp.spEngine.setScalingFactor(scale.intValue());

		return null;
	}

}
