/*
 * $Id: Sprite.java,v 1.3 2008/08/31 17:12:56 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * SPRITE ON/OFF/STOPD
 * <br><pre>
 * @\FXvCgՓˎ̊荞݂𐧌䂷D
 * ʁFR}h
 * FSPRITE {ON|OFF|STOP}
 * ᕶFSPRITE ON
 *     @SPRITE OFF
 *     @SPRITE STOP
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Sprite implements BuiltinCommand {
	/** XvCg荞 ON */
	public static final int INT_ON = 1;
	/** XvCg荞 STOP */
	public static final int INT_STOP = 2;
	/** XvCg荞 OFF */
	public static final int INT_OFF = 3;

	/** XvCg荞ݏ */
	public static int interrupt = INT_ON;
	/** XvCg荞ݔ̈ړsԍ */
	public static int lineno = -1;

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Token token = line.getNextValidToken();

		if(token != null && "ON".equals(token.toString())) {
			// 荞݊Jn
			interrupt = INT_ON;
		} else if(token != null && "OFF".equals(token.toString())) {
			// 荞ݒ~
			interrupt = INT_OFF;
		} else if(token != null && "STOP".equals(token.toString())) {
			// 荞݈ꎞ~
			interrupt = INT_STOP;
		} else {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		// XvCg荞݃[h̐ݒ
		return null;
	}

}
