/*
 * $Id: Stick.java,v 1.1 2009/04/20 18:00:12 akabane Exp $
 */
package org.logical_paradox.petitbasic.gui.ext;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;
import org.logical_paradox.petitbasic.gui.bios.ASCIICode;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.sysvar.SystemVariable;
import org.logical_paradox.petitbasic.sysvar.SystemVariableContext;

/**
 * STICKD
 * <br><pre>
 * @\FJ[\L[̏ԂԂD
 * ʁFVXeϐ
 * FSTICK(<>)
 * @@@@@0: L[{[h
 * ᕶFS=STICK(0)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Stick implements SystemVariable {
	private static final int cursorKeySnsFlt[] = new int[] { ASCIICode.UP, ASCIICode.RI, ASCIICode.DW, ASCIICode.LE };
	private static final int stickState[] = new int[] {
		0, 1, 3, 2, 5, 0, 4, 0, 7, 8, 0, 0, 6, 0, 0, 0
	};

	/**
	 * VXeϐɑ΂ĒlD
	 * ̃\bh́CVXeϐɑ΂ɌĂяoD
	 * @param svc VXeϐReLXg
	 * @throws BasicLanguageException BASICsG[
	 */
	public void assign(SystemVariableContext svc) throws BasicLanguageException {
		throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
	}
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();

		if(
			expr.hasNextToken() ||
			token.getType() != Token.TYPE_LITERAL
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}

		int param = OperationUtils.intValue(token, ctx);
		int value = 0;
		switch(param) {
			case 0:				// J[\L[
				long keyState = PetitBasicGuiRuntimeEnvHolder.getEnvironment().keyInputDevice.getKeyState(1);
				int idx = 0;
				for(int i = 0; i < cursorKeySnsFlt.length; i++) {
					if((keyState & (1L << (long)cursorKeySnsFlt[i])) != 0) {
						idx |= 1 << i;
					}
				}
				
				value = stickState[idx];
				break;
			default:
				// ͈̔͂
				throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
		}
		
		Token result = new Token(Token.TYPE_LITERAL);
		result.setIntValue(value);
		result.setValueType(Token.VTYPE_INT);
		result.setDecimalFormat(Token.DF_INT);

		return result;
	}

}
