/*
 * $Id: Display.java,v 1.10 2008/10/08 18:23:46 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.swing.JFrame;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnvHolder;


/**
 * Petit-BASICzʁD
 * zʂ̓OtBbNVRAMCeLXgVRAMȂǂ\D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.10 $
 */
public class Display {
	/** zʉTCY(P:pixel) */
	private final int horizon;
	/** zʏcTCY(P:pixel) */
	private final int vertical;
	/**  */
	private final Component baseComponent;
	private BufferedImage bi;
	/** 摜C[ */
	private final List planes = new ArrayList();
	/** ʕ`悪ǂ̃tO */
	private boolean repaintFlag = false;
	private Object vsyncWaitLock = new Object();

	/** tXN[[h */
	private boolean fullScreen = false;

	/**
	 * RXgN^D
	 * @param h zʉTCY
	 * @param v zʏcTCY
	 */
	public Display(Component compo, int h, int v) {
		horizon = h;
		vertical = v;
		baseComponent = compo;
		bi = new BufferedImage(horizon, vertical, BufferedImage.TYPE_INT_RGB);
	}
	/**
	 * zʂ̉TCYԂD
	 * @return zʂ̉TCY
	 */
	public int getHorizonSize() {
		return horizon;
	}
	/**
	 * zʂ̏cTCYԂD
	 * @return zʂ̏cTCY
	 */
	public int getVerticalSize() {
		return vertical;
	}
	/**
	 * tXN[[hɐݒ肷D
	 * @param b
	 */
	public void setFullScreen(boolean b) {
		PetitBasicGuiRuntimeEnv env = PetitBasicGuiRuntimeEnvHolder.getEnvironment();
		JFrame frame = env.rootFrame;

		if(frame == null) {
			// AvbgNꂽꍇCtXN[[hɐݒłȂ
			return;
		}
		GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
		if(!device.isFullScreenSupported()) {
			// ̃foCX̓tXN[\̓T|[gĂȂ
			return;
		}
		
		if(fullScreen && !b) {
			// EBhE\ɖ߂
			frame.dispose();
			frame.setUndecorated(false);
//			device.setDisplayMode(wndDispMode);		???? Ȃs邪AȂĂ삷??
			device.setFullScreenWindow(null);
			frame.setVisible(true);
		} else if(!fullScreen && b) {
			// tXN[\
			frame.dispose();
			frame.setVisible(false);
			frame.setUndecorated(true);
			DisplayMode mode = new DisplayMode(horizon, vertical, 32, DisplayMode.REFRESH_RATE_UNKNOWN);
			device.setFullScreenWindow(frame);
			device.setDisplayMode(mode);
			frame.setVisible(true);
		}

		fullScreen = b;
	}
	/**
	 * 摜C[ǉD
	 * ǉꂽ摜C[͒ɗD揇Ƀ\[gD
	 * @param p v[
	 */
	public void add(Plane p) {
		planes.add(p);
		Collections.sort(planes);
	}
	/**
	 * `̈ɑ΂āC摜C[̓e]D
	 * @param g `Ώۗ̈
	 * @param config RtBO[V
	 */
	public void paint(Graphics g, PetitBasicGuiConfig config) {
		if(g == null) {
			return;
		}

		// wiF
		Graphics graphics = bi.getGraphics();
		Color brush = graphics.getColor();
		graphics.setColor(config.getWindowBgcolor());
		graphics.fillRect(0, 0, horizon, vertical);
		graphics.setColor(brush);

		for(Iterator it = planes.iterator(); it.hasNext();) {
			Plane chip = (Plane)it.next();
			chip.renderImage(bi);
		}
		g.drawImage(bi, 0, 0, null);
		
		// A҂ĂXbhN
		repaintFlag = !repaintFlag;
		synchronized(vsyncWaitLock) {
			vsyncWaitLock.notify();
		}
	}
	/**
	 * zʂĕ`悷D
	 * @param config RtBO[V
	 */
	public void repaint2(PetitBasicGuiConfig config) {
		paint(baseComponent.getGraphics(), config);
	}
	public void repaint(PetitBasicGuiConfig config) {
	}
	/**
	 * A(VSYNC)҂킹B
	 */
	public void vsync() {
		try {
			boolean beginningStatus = repaintFlag;
			synchronized(vsyncWaitLock) {
				while(beginningStatus == repaintFlag) {
					wait();
				}
			}
		} catch(InterruptedException e) {
			// AԂ̑҂킹Ɏs
			// ̂܂ܕԂDʂ͂ǂȂ邩m
		}
	}
}
