/*
 * $Id: GraphicVRAM.java,v 1.8 2008/06/04 17:31:30 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

/**
 * OtBbNVRAMD
 * rbg}bv\\VRAMDWn̒Pʂ̓hbgD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class GraphicVRAM implements VRAM {
	/** \̈扡TCY */
	private final int width;
	/** \̈cTCY */
	private final int height;
	/** v[̕`vCIeB */
	private final int priority;

	/** rbg}bvf[^ */
	private BufferedImage bitmap;
	/** rbg}bvobt@ */
	private int[] imgbuf = null;
	/** \ */
	private boolean enabled = true;

	/**
	 * RXgN^D
	 * @param x TCY
	 * @param y cTCY
	 * @param prio ̃v[̕`D揇(قǗDxႢ)
	 */
	public GraphicVRAM(int x, int y, int prio) {
		width = x;
		height = y;
		priority = prio;
		clear();
	}
	/**
	 * rbg}bvf[^ԂD
	 * @return rbg}bvf[^
	 */
	public BufferedImage getBitmap() {
		return bitmap;
	}
	/**
	 * 摜`悷D
	 * @param bi 摜obt@
	 */
	public void renderImage(BufferedImage bi) {
		if(isEnable() == false) {
			return;
		}
		
		Graphics g = bi.getGraphics();
		g.drawImage(bitmap, 0, 0, null);
		g.dispose();
	}
	/**
	 * DxrD
	 * @param arg0 rΏ
	 * @return 0: 1: -1:Ⴂ
	 */
	public int compareTo(Object arg0) {
		Plane buddy = (Plane)arg0;
		if(buddy.getPriority() == getPriority()) {
			return 0;
		}
		return buddy.getPriority() < getPriority() ? 1 : -1;
	}
	/**
	 * v[̕`D揇ʂԂD
	 * @return D揇
	 */
	public int getPriority() {
		return priority;
	}
	/**
	 * wWɑ΂ăf[^ށD
	 * @param x XW
	 * @param y YW
	 * @param data ރf[^
	 */
	public void vpoke(int x, int y, int data) {
		imgbuf[y * width + x] = data;
	}
	/**
	 * wWɑ΂Ă܂Ƃ߂ăf[^ށD
	 * @param x XW
	 * @param y YW
	 * @param data ރf[^
	 */
	public void vpoke(int x, int y, int[] data) {
		for(int i = 0; i < data.length; i++) {
			if(x >= width) {
				// `̈̒[܂łĂꍇ͉s
				x = 0;
				y++;
			}
			if(y >= height) {
				// `̈̉t܂łꍇ́C`悵Ăǂʂɂ͕\Ȃ
				return;
			}
			imgbuf[y * width + x] = data[i];
			x++;
		}
	}
	/**
	 * wW̃f[^擾D
	 * @param x XW
	 * @param y YW
	 * @return ǂݍ񂾃f[^
	 */
	public int vpeek(int x, int y) {
		return imgbuf[y * width + x];
	}
	/**
	 * wWw肳ꂽf[^擾D
	 * @param x XW
	 * @param y YW
	 * @param len ǂݍޒ
	 * @return ǂݍ񂾃f[^
	 */
	public int[] vpeek(int x, int y, int len) {
		int[] data = new int[len];

		for(int i = 0; i < len; i++) {
			if(x >= width) {
				// `̈̒[܂łĂꍇ͉s
				x = 0;
				y++;
			}
			if(y >= height) {
				// `̈̉t܂łꍇ́C`悵Ăǂʂɂ͕\Ȃ
				break;
			}
			data[i] = imgbuf[y * width + x];
			x++;
		}

		return data;
	}
	/**
	 * D
	 */
	public void clear() {
		bitmap = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		DataBufferInt dbi = (DataBufferInt)bitmap.getRaster().getDataBuffer();
		imgbuf = dbi.getData();
	}
	/**
	 * VRAMzʏɕ`悷邩ǂݒ肷D
	 * @param b true: \Ώ / false: \
	 */
	public void setEnable(boolean b) {
		enabled = b;
	}
	/**
	 * VRAMzʏɕ`悳邩ǂԂD
	 * @return true: \Ώ / false: \
	 */
	public boolean isEnable() {
		return enabled;
	}
}
