/*
 * $Id: KeyInputDevice.java,v 1.19 2009/05/10 13:24:41 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiRuntimeEnv;
import org.logical_paradox.petitbasic.gui.bios.ASCIICode;
import org.logical_paradox.petitbasic.gui.bios.FIFO;

/**
 * zL[̓foCX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.19 $
 */
public class KeyInputDevice implements KeyListener {
	/** ^C */
	private final PetitBasicGuiRuntimeEnv env;

	/** SHIFTL[ */
	public boolean shiftKeyPressed = false;
	/** CTRLL[ */
	public boolean ctrlKeyPressed = false;

	/** L[ */
	private Set keyState = new HashSet();
	/** ŌɉꂽL[ */
	private char lastPressedKeyChar = '\u0000';

	/** L[R[h`ASCIIR[hϊ}bv */
	private static final Map keycodeMapping;

	/*
	 * X^eBbNCjVCU
	 */
	static {
		Map map = new HashMap();

		map.put(new Integer(KeyEvent.VK_UP), new Character(ASCIICode.UP));
		map.put(new Integer(KeyEvent.VK_DOWN), new Character(ASCIICode.DW));
		map.put(new Integer(KeyEvent.VK_RIGHT), new Character(ASCIICode.RI));
		map.put(new Integer(KeyEvent.VK_LEFT), new Character(ASCIICode.LE));
		map.put(new Integer(KeyEvent.VK_HOME), new Character(ASCIICode.HO));
		map.put(new Integer(KeyEvent.VK_ENTER), new Character(ASCIICode.LF));
		map.put(new Integer(KeyEvent.VK_INSERT), new Character(ASCIICode.IS));

		keycodeMapping = Collections.unmodifiableMap(map);
		
	}
	/**
	 * RXgN^D
	 * @param e ^C
	 */
	public KeyInputDevice(PetitBasicGuiRuntimeEnv e) {
		env = e;
	}
	/**
	 * L[͂ꂽۂɔCxgD
	 * @param e CxgIuWFNg
	 */
	public void keyTyped(KeyEvent e) {
	}
	/**
	 * L[ꂽۂɔCxgD
	 * @param e CxgIuWFNg
	 */
	public void keyPressed(KeyEvent e) {
		FIFO fifo = env.getKeyInputBuffer();
		boolean consume = false;
		synchronized(fifo) {
			char c = e.getKeyChar();
			switch(e.getKeyCode()) {
				case KeyEvent.VK_UP:
				case KeyEvent.VK_DOWN:
				case KeyEvent.VK_RIGHT:
				case KeyEvent.VK_LEFT:
				case KeyEvent.VK_HOME:
					c = ((Character)keycodeMapping.get(new Integer(e.getKeyCode()))).charValue();
					break;
				case KeyEvent.VK_ENTER:
					// ENTERL[CR+LFɕϊ
					fifo.enqueue("" + ASCIICode.CR);
					c = ASCIICode.LF;
					break;
				case KeyEvent.VK_C:
					if(ctrlKeyPressed == true) {
						// CTRL+C
						if(env.runtime.getRuntimeEnvironment().running) {
							// s̏ꍇɂ̂݁CbreaktOݒ肷
							env.screenEditor.breakFlag = true;
							consume = true;
//							c = 'C';
						} else {
							if(env.autoLineNumber == true) {
								env.autoLineNumber = false;
							}
							// A
							fifo.enqueue("" + ASCIICode.LF);
							c = ASCIICode.CR;
						}
						fifo.setTrigger();
						fifo.notify();
					}
					break;
				case KeyEvent.VK_G:
					if(ctrlKeyPressed == true) {
						// CTRL+G
						env.md.beep();
						consume = true;
					}
					break;
				case KeyEvent.VK_F1:
				case KeyEvent.VK_F2:
				case KeyEvent.VK_F3:
				case KeyEvent.VK_F4:
				case KeyEvent.VK_F5:
				case KeyEvent.VK_F6:
					inputFunctionKey(fifo, e.getKeyCode(), e);
					consume = true;
					break;
				case KeyEvent.VK_INSERT:
					c = ((Character)keycodeMapping.get(new Integer(e.getKeyCode()))).charValue();
					break;
				// ̃Rg[L[(1ƂĎʂȂ)̓L[̓obt@ɓo^Ȃ
				case KeyEvent.VK_F7:
				case KeyEvent.VK_F8:
				case KeyEvent.VK_F9:
				case KeyEvent.VK_F10:
				case KeyEvent.VK_F11:
				case KeyEvent.VK_F12:
				case KeyEvent.VK_CONVERT:
				case KeyEvent.VK_INPUT_METHOD_ON_OFF:
				case KeyEvent.VK_ALT:
				case KeyEvent.VK_WINDOWS:
				case KeyEvent.VK_SCROLL_LOCK:
				case KeyEvent.VK_ROMAN_CHARACTERS:
				case KeyEvent.VK_PRINTSCREEN:
				case KeyEvent.VK_PREVIOUS_CANDIDATE:
				case KeyEvent.VK_ALL_CANDIDATES:
				case KeyEvent.VK_CONTEXT_MENU:
				case KeyEvent.VK_CAPS_LOCK:
				case KeyEvent.VK_ALPHANUMERIC:
				case KeyEvent.VK_KATAKANA:
				case KeyEvent.VK_HIRAGANA:
				case KeyEvent.VK_FULL_WIDTH:
				case KeyEvent.VK_HALF_WIDTH:
				case KeyEvent.VK_NONCONVERT:
				case KeyEvent.VK_CONTROL:
				case KeyEvent.VK_SHIFT:
				case KeyEvent.VK_PAGE_DOWN:
				case KeyEvent.VK_PAGE_UP:
					consume = true;
					e.consume();
					break;
			}
			
			if(c == 65535) {
				// L[蓖Ă̂Ȃgݍ킹ꂽꍇ
				consume = true;
				e.consume();
			} else {
				// L[Ԃ̕ۑ
				synchronized(keyState) {
					keyState.add(new Character(c));
					lastPressedKeyChar = c;
				}
			}

			if(consume == false) {
				fifo.enqueue("" + c);
				fifo.notify();
			} else {
				switch(e.getKeyCode()) {
					case KeyEvent.VK_CONTROL:
						ctrlKeyPressed = true;
						break;
					case KeyEvent.VK_SHIFT:
						if(shiftKeyPressed == false) {
							// t@NVL[\̐؂ւ
							env.config.functionKeyDisplayShift = true;
							env.screenEditor.show(true);
						}
						shiftKeyPressed = true;
						break;
				}
			}
		}
	}
	/**
	 * L[ꂽۂɔCxgD
	 * @param e CxgIuWFNg
	 */
	public void keyReleased(KeyEvent e) {
		switch(e.getKeyCode()) {
			case KeyEvent.VK_CONTROL:
				ctrlKeyPressed = false;
				break;
			case KeyEvent.VK_SHIFT:
				shiftKeyPressed = false;
				// t@NVL[\̐؂ւ
				env.config.functionKeyDisplayShift = false;
				env.screenEditor.show(true);
				break;
		}

		// L[Ԃ̉
		Character cc = (Character)keycodeMapping.get(new Integer(e.getKeyCode()));
		if (cc != null) {
			synchronized(keyState) {
				keyState.remove(cc);
			}
		}
		lastPressedKeyChar = '\u0000';
	}
	/**
	 * t@NVL[́D
	 * @param fifo L[̓obt@
	 * @param c L[R[h
	 * @param e L[̓CxgIuWFNg
	 */
	protected void inputFunctionKey(FIFO fifo, int c, KeyEvent e) {
		int functionKeyIndex = c - KeyEvent.VK_F1 + (shiftKeyPressed ? 6 : 0);		// ȂsV̈R[h
		String input = env.config.functionKeyStrings[functionKeyIndex];
		fifo.enqueue(input);
		fifo.notify();
		
		e.consume();
	}
	/**
	 * ŌɉꂽL[ɑΉLN^Ԃ.
	 * shiftL[Ȃǂ̃L[͖D
	 * @return ŌɉꂽL[ɑΉLN^('\u0000': ĂȂ)
	 */
	public char getLastPressedKeyChar() {
		return lastPressedKeyChar == 65535 ? '\u0000' : lastPressedKeyChar;
	}
	/**
	 * w肳ꂽL[Ă邩ǂԂD
	 * @param c mFLN^
	 * @return true: Ă / false:[XĂ
	 */
	public boolean isKeyPressing(char c) {
		return keyState.contains(new Character(c));
	}
	/**
	 * L[{[h̉Ԃ擾B
	 * @param lineno sԍ
	 * @return (ebitƂA0: / 1:[X)
	 */
	public long getKeyState(int lineno) {
		long bit = 0L;
		int min = (lineno - 1) * 64;
		int max = min + 63;

		if(lineno == 0) {
			// sԍ0́CRg[L[̏ԂԂ
		} else {
			// sԍ1ȏ́CASCIIR[h0ȏ̏ԂԂ
			synchronized(keyState) {
				for(Iterator it = keyState.iterator(); it.hasNext();) {
					int c = ((Character)it.next()).charValue();
					if(c >= min && c <= max) {
						// Ybiton
						bit |= 1L << (c % 64L);
					}
				}
			}
		}
		return bit;
	}
}
