/*
 * $Id: SpriteEngine.java,v 1.10 2009/05/10 13:24:41 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;

/**
 * XvCgGWD
 * XvCg\ɊւSĂ̋@\ێD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.10 $
 */
public class SpriteEngine implements Plane {
	/** XvCg[h - 8x8 */
	public static final int SPRITE_SIZE_8x8 = 8;
	/** XvCg[h - 16x16 */
	public static final int SPRITE_SIZE_16x16= 16;
	/** XvCg[h - 32x32 */
	public static final int SPRITE_SIZE_32x32 = 32;

	/** XP[Ot@N^ - x1 */
	public static final int SCALING_FACTOR_x1 = 1;
	/** XP[Ot@N^ - x2 */
	public static final int SCALING_FACTOR_x2 = 2;
	/** XP[Ot@N^ - x4 */
	public static final int SCALING_FACTOR_x4 = 4;

	/** XvCg̃TCY */
	public Dimension spriteSize;

	/** v[̕`vCIeB */
	public final int priority;
	/** GUIRtBO[V */
	public final PetitBasicGuiConfig config;

	/** ݂̃XvCg[h */
	private int spriteMode = SPRITE_SIZE_8x8;
	/** ݂̃XP[Ot@N^ */
	private int scalingFactor = SCALING_FACTOR_x1;
	/** XvCgp^[ */
	private SpritePattern[] sprites;
	/** XvCge[u */
	private SpriteAttribute[] attributes;
	
	/** \ */
	private boolean enabled = true;
	/** XvCg[h - sNZϊ}bv */
	private static final Map spriteSizeMap;
	
	/** XvCgՓ˂Ă邩ǂ */
	private boolean conflict = false;

	/** Փ˂XvCg̃Xg */
	private Map conflictSprites = new HashMap();

	/*
	 * X^eBbNCjVCU
	 */
	static {
		Map map = new HashMap();
		map.put(new Integer(SPRITE_SIZE_8x8), new Integer(8));
		map.put(new Integer(SPRITE_SIZE_16x16), new Integer(16));
		map.put(new Integer(SPRITE_SIZE_32x32), new Integer(32));
		spriteSizeMap = Collections.unmodifiableMap(map);
	}
	/**
	 * RXgN^D
	 * @param prio ̃v[̕`D揇(قǗDxႢ)
	 * @param gc PetitBASIC GUIRtBO[V
	 */
	public SpriteEngine(int prio, PetitBasicGuiConfig gc) {
		priority = prio;
		config = gc;

		sprites = new SpritePattern[gc.getSpriteDeclMaxCount()];
		attributes = new SpriteAttribute[gc.getSpriteDispMaxCount()];

		clear();
	}
	/**
	 * XvCgՓ˂Ă邩ǂԂD
	 * x擾ƁCZbgD
	 * @return true:Փ˂Ă / false:Փ˂ĂȂ
	 */
	public boolean isConflicted() {
		boolean cf = conflict;
		conflict = false;
		
		return cf;
	}
	/**
	 * w肵XvCgp^[ԍXWԂD
	 * @param sprno XvCgp^[ԍ
	 * @return XW
	 */
	public int getSpriteXCoordinate(int sprno) {
		return attributes[sprno].x;
	}
	/**
	 * w肵XvCgp^[ԍYWԂB
	 * @param sprno XvCgp^[ԍ
	 * @return YW
	 */
	public int getSpriteYCoordinate(int sprno) {
		return attributes[sprno].y;
	}
	/**
	 * w肳ꂽXvCgƏՓ˂ĂXvCg̃XgԂD
	 * xoƁCXg폜D
	 * @param sprno XvCgʔԍ
	 * @return Ce[^(null:Ȃ)
	 */
	public Iterator getConflictIterator(int sprno) {
		return (Iterator)conflictSprites.get(new Integer(sprno));
	}
	/**
	 * w肵XvCgw肵ʒuֈړ.<br/>
	 * ړɂăXvCgm̏Փ˂ꍇCՓ˃CxgƂČo.
	 * @param sprno XvCgp^[ԍ
	 * @param x XW
	 * @param y YW
	 */
	public void moveSprite(int sprno, int x, int y) {
		conflict = false;
		List buddies = new ArrayList();

		SpriteAttribute attr = attributes[sprno];

		attr.x = x;
		attr.y = y;

		if(attr.disp && attr.entity) {
			int size = spriteMode * scalingFactor;
			Rectangle myrect = new Rectangle(attr.x, attr.y, size, size);

			for(int i = 0; i < attributes.length; i++) {
				if(sprno == i) {
					continue;
				}
				SpriteAttribute buddy = attributes[i];
				if(!buddy.disp || !buddy.entity) {
					// r肪\łȂCՓ˂̂ێĂȂ
					continue;
				}
				Rectangle br = new Rectangle(buddy.x, buddy.y, size, size);
				if(!myrect.intersects(br)) {
					// XvCg̐L̈擯mՓ˂ĂȂꍇC̃XvCg
					continue;
				}
				int[] ptn0 = sprites[attr.ptno].getLinePattern();		// ̃XvCgp^[
				int[] ptn1 = sprites[buddy.ptno].getLinePattern();		// ̃XvCgp^[
				int diffx = attr.x - buddy.x;
				int diffy = attr.y - buddy.y;

				for(int sy = attr.y, dy = 0; sy < attr.y + size; sy++, dy++) {
					if(buddy.y <= sy && sy < buddy.y + size) {
						int d0 = ptn0[dy / scalingFactor];
						int d1 = ptn1[(dy + diffy) / scalingFactor];
						// {ɍ킹ăXvCg̃rbgp^[g傷
						long[] d0bp = expandSpritePattern(d0, scalingFactor);
						long[] d1bp = expandSpritePattern(d1, scalingFactor);

						if(diffx >= 0) {
							// Eɂ邩Cʒuɂ
							d0bp[1] >>>= (long)diffx;
							d0bp[0] = (d0bp[0] >>> (long)diffx) | (d0bp[1] << (64L - (long)diffx));
						} else {
							// 肪Eɂ
							d1bp[1] >>>= (long)-diffx;
							d1bp[0] = (d1bp[0] >>> (long)-diffx) | (d1bp[1] << (64L - (long)-diffx));
						}
						if((d0bp[0] & d1bp[0]) != 0 || (d0bp[1] & d1bp[1]) != 0) {
							// Փ˂Ă
							conflict = true;
							buddies.add(new Integer(i));
						}
					}
				}
			}
		}
		Integer key = new Integer(sprno);
		if(buddies.size() == 0 && conflictSprites.containsKey(key)) {
			// Փ˂XvCgȂꍇ̓NA
			conflictSprites.remove(key);
		} else {
			// ړXvCgƏՓ˂ĂXvCg̃Xgǉ
			conflictSprites.put(key, buddies.iterator());
		}
	}
	/**
	 * XvCg̃rbgp^[(1s)w萮{ɂĈL΂B
	 * @param d XvCg̃rbgp^[(1s)\(ő32bit܂)
	 * @param er {(x1, x2, x4̂ꂩ̂ݎw)
	 * @return g傳ꂽrbgp^[(). v[0]ɉ32bitCv[1]ɏ32biti[.
	 */
	protected long[] expandSpritePattern(long d, int er) {
		long[] v = {0L, 0L};
		long a = 1;
		int cnt = 0;
		int bitcnt = 0;
		for(int i = 0; i < 32; i++) {
			for(int j = 0; j < er; j++) {
				v[cnt] |= a * (d & 1);
				a <<= 1L;
				bitcnt++;
			}
			if(bitcnt == 64) {
				cnt++;
				bitcnt = 0;
				a = 1;
			}
			d >>>= 1L;
		}
		
		return v;
	}
	/**
	 * w肵XvCgw肵ʒuֈړ.<br/>
	 * ړɂăXvCgm̏Փ˂ꍇCՓ˃CxgƂČo.
	 * @param sprno XvCgʔԍ
	 * @param x XW
	 * @param y YW
	 * @param cc J[R[h
	 * @param ptnno XvCgp^[ԍ
	 * @param true:\ / false:\
	 */
	public void moveSprite(int sprno, int x, int y, int cc, int ptnno, boolean shown) {
		SpriteAttribute attr = attributes[sprno];
		attr.color = cc;
		attr.disp = shown;
		attr.ptno = ptnno;
		
		moveSprite(sprno, x, y);
	}
	/**
	 * w肵XvCǧ݂̕\FԂ.
	 * @param sprno XvCgp^[ԍ
	 * @return J[R[h
	 */
	public int getSpriteColor(int sprno) {
		return attributes[sprno].color;
	}
	/**
	 * w肵XvCǧ݂̕\Fݒ肷.
	 * @param sprno XvCgp^[ԍ
	 * @param cc J[R[h
	 */
	public void setSpriteColor(int sprno, int cc) {
		attributes[sprno].color = cc;
	}
	/**
	 * w肵XvCǧ݂̕\ԂԂ.
	 * @param sprno XvCgp^[ԍ
	 * @return true:\ / false:\
	 */
	public boolean isSpriteShown(int sprno) {
		return attributes[sprno].disp;
	}
	/**
	 * w肵XvCǧ݂̕\Ԃݒ肷.
	 * @param sprno XvCgp^[ԍ
	 * @param shown true:\ / false:\
	 */
	public void setSpriteShown(int sprno, boolean shown) {
		attributes[sprno].disp = shown;
	}
	/**
	 * XvCg`\ԂD
	 * @return XvCg`\
	 */
	public int getSpriteMaxDecl() {
		return sprites.length;
	}
	/**
	 * ݂̃XP[Ot@N^ԂD
	 * @return XP[Ot@N^
	 */
	public int getScalingFactor() {
		return scalingFactor;
	}
	/**
	 * XP[Ot@N^ݒ肷.
	 * @param scalingFactor XP[Ot@N^
	 */
	public void setScalingFactor(int scalingFactor) {
		this.scalingFactor = scalingFactor;
	}
	/**
	 * ݂̃XvCg[hԂB
	 * @return XvCg[h
	 */
	public int getSpriteMode() {
		return spriteMode;
	}
	/**
	 * ݂̃XvCg[hݒ肷B
	 * XvCg[hύXƁCXvCgSďB
	 * @param spriteMode XvCg[h
	 */
	public void setSpriteMode(int spriteMode) {
		this.spriteMode = spriteMode;
		clear();
	}
	/**
	 * XvCgp^[`D
	 * @param ptnno XvCgԍ
	 * @param sprite XvCgp^[
	 */
	public void setSprite(int ptnno, SpritePattern sprite) {
		sprites[ptnno] = sprite;
	}
	/**
	 * XvCgԂD
	 * @param dispno XvCgʔԍ
	 * @return XvCg
	 */
	protected SpriteAttribute getSpriteAttribute(int dispno) {
		return attributes[dispno];
	}
	/**
	 * XvCgp^[ԂD
	 * @param ptnno XvCgԍ
	 * @return XvCgp^[
	 */
	public SpritePattern getSprite(int ptnno) {
		return sprites[ptnno];
	}
	/**
	 * 摜`悷D
	 * @param bi 摜obt@
	 */
	public void renderImage(BufferedImage bi) {
		if(isEnable() == false) {
			return;
		}
		
		int[] buf = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
		int windowWidth  = config.getWindowWidth();
		int windowHeight = config.getWindowHeight();

		// XvCg`悷
		for(int i = 0; i < attributes.length; i++) {
			SpriteAttribute attr = attributes[i];
			SpritePattern spp = null;
			if(attr.disp && (spp = sprites[attr.ptno]) != null) {
				int sx = attr.x;
				int sy = attr.y;
				int[][] ptn = spp.getBitmap();
				for(int y = 0; y < spp.height; y++) {
					for(int x  = 0; x < spp.width; x++) {
						if (ptn[y][x] != 0) {
							for(int j = 0; j < scalingFactor; j++) {
								for(int k = 0; k < scalingFactor; k++) {
									int px = (sx + (x * scalingFactor) + k);
									int py = (sy + (y * scalingFactor) + j);
									if(0 < px && px < windowWidth && 0 < py && py < windowHeight) {
										buf[py * windowWidth + px] = config.colorPallet[attr.color].getRGB();
									}
								}
							}
						}
					}
				}
			}
		}
	}
	/**
	 * v[̕`D揇ʂԂD
	 * @return D揇
	 */
	public int getPriority() {
		return priority;
	}
	/**
	 * D
	 */
	public void clear() {
		sprites = new SpritePattern[sprites.length];

		// XvCge[ȕ
		for(int i = 0; i < attributes.length; i++) {
			attributes[i] = new SpriteAttribute();
		}

		// XvCgTCYݒ肷
		Integer size = (Integer)spriteSizeMap.get(new Integer(spriteMode));
		if(size == null) {
			throw new IllegalArgumentException("sȃXvCg[hݒ肳Ă܂:" + spriteMode);
		}

		spriteSize = new Dimension(size.intValue(), size.intValue());
		conflict = false;
		conflictSprites.clear();
	}
	/**
	 * DxrD
	 * @param arg0 rΏ
	 * @return 0: 1: -1:Ⴂ
	 */
	public int compareTo(Object arg0) {
		Plane buddy = (Plane)arg0;
		if(buddy.getPriority() == getPriority()) {
			return 0;
		}
		return buddy.getPriority() < getPriority() ? 1 : -1;
	}
	/**
	 * VRAMzʏɕ`悷邩ǂݒ肷D
	 * @param b true: \Ώ / false: \
	 */
	public void setEnable(boolean b) {
		enabled = b;
	}
	/**
	 * VRAMzʏɕ`悳邩ǂԂD
	 * @return true: \Ώ / false: \
	 */
	public boolean isEnable() {
		return enabled;
	}
}
