/*
 * $Id: TextVRAM.java,v 1.11 2009/05/10 13:24:41 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.gui.hardware;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Vector;

import org.logical_paradox.petitbasic.gui.Cursor;
import org.logical_paradox.petitbasic.gui.PetitBasicGuiConfig;
import org.logical_paradox.petitbasic.gui.bios.FontDriver;


/**
 * eLXgVRAMD
 * LN^Pʂ̍WnێCPʂł̏o͂\ƂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.11 $
 */
public class TextVRAM implements VRAM {
	/** v[̕`vCIeB */
	private final int priority;
	/** \̈扡TCY */
	private final int width;
	/** \̈cTCY */
	private final int height;
	/** tHghCo */
	private final FontDriver fd;
	/** eLXgVRAM̓e */
	private Vector map;
	/** XV}bv */
	private boolean[] dirtymap;
	/** rbg}bvLbV */
	private BufferedImage bitmap;
	/** _[eBtO */
	private boolean dirty;
	/** \ */
	private boolean enabled = true;
	/** J[\ */
	private Cursor cursor;
	/** PetitBASIC GUIRtBO */
	private PetitBasicGuiConfig config;

	/**
	 * RXgN^D
	 * @param x LN^Wn̉TCY
	 * @param y LN^Wn̏cTCY
	 * @param prio `D揇
	 * @param d tHghCo
	 * @param cs J[\
	 */
	public TextVRAM(int x, int y, int prio, PetitBasicGuiConfig c, FontDriver d, Cursor cs) {
		width = x;
		height = y;
		priority = prio;
		fd = d;
		cursor = cs;
		config = c;
		clear();
	}
	/**
	 * 摜`悷D
	 * @param bi 摜obt@
	 */
	public void renderImage(BufferedImage bi) {
		if(isEnable() == false) {
			return;
		}

		if(dirty) {
			// rbg}bvLbV̍č\z
			for(int y = 0; y < height; y++) {
				if(dirtymap[y] == false) {
					// ̍s͍XVĂȂ̂Ŗ
					continue;
				}
				StringBuffer sb = new StringBuffer();
				int[] line = (int[])map.get(y);
				for(int x = 0; x < width; x++) {
					char c = (char)line[x];
					if(Character.isLetterOrDigit(c) == false) {
						// \łȂLN^̏ꍇCwhitespaceɕϊĕ`悷
						c = ' ';
					}
					sb.append(line[x] < 32 ? ' ' : (char)line[x]);
				}
				fd.drawString(bitmap, 0, y * fd.getFontHeight(), sb.toString(), config.getWindowForecolor());
				dirtymap[y] = false;
			}
			dirty = false;
		}
		// rbg}bv̓]
		Graphics g = bi.getGraphics();
		g.drawImage(bitmap, 0, 0, null);
		
		if(cursor.isShown()) {
			// J[\̕\
			cursor.show(bi);
		}
		g.dispose();
	}
	/**
	 * tHg`.
	 * @param c LN^
	 * @param ptn tHgp^[
	 */
	public void defineFont(char c, int[] ptn) {
		fd.defineFont(c, ptn);
	}
	/**
	 * tHgG[`.
	 * @param c LN^
	 * @param foreColor OiF
	 * @param bgColor wiF
	 */
	public void defineFontColor(char c, int foreColor, int bgColor) {
		Color fc = config.colorPallet[foreColor];
		Color bc = config.colorPallet[bgColor];

		fd.defineColor(c, fc, bc);
	}
	/**
	 * tHg̒`.
	 */
	public void initFont() {
		fd.initFont();
	}
	/**
	 * tHgG[̒`.
	 */
	public void initFontColor() {
		fd.initFontColor();
	}
	/**
	 * `D揇ʂԂD
	 * @return `D揇
	 */
	public int getPriority() {
		return priority;
	}
	/**
	 * wWɑ΂ăf[^ށD
	 * @param x XW
	 * @param y YW
	 * @param data ރf[^
	 */
	public void vpoke(int x, int y, int data) {
		int linecnt = x / width;
		x %= width;
		y = y + linecnt >= height ? height : y + linecnt;

		int[] line = (int[])map.get(y);
		line[x] = data;
		dirty = true;
		dirtymap[y] = true;
	}
	/**
	 * wWɑ΂Ă܂Ƃ߂ăf[^ށD
	 * @param x XW
	 * @param y YW
	 * @param data ރf[^
	 */
	public void vpoke(int x, int y, int[] data) {
		for(int i = 0; i < data.length; i++) {
			vpoke(x+i, y, data[i]);
			dirtymap[y] = true;
		}
	}
	/**
	 * wW̃f[^擾D
	 * @param x XW
	 * @param y YW
	 * @return ǂݍ񂾃f[^
	 */
	public int vpeek(int x, int y) {
		int linecnt = x / width;
		x %= width;
		y = y + linecnt >= height ? height : y + linecnt;

		int[] line = (int[])map.get(y);
		int data = line[x];
		return data;
	}
	/**
	 * wWw肳ꂽf[^擾D
	 * @param x XW
	 * @param y YW
	 * @param len ǂݍޒ
	 * @return ǂݍ񂾃f[^
	 */
	public int[] vpeek(int x, int y, int len) {
		if(len < 0) {
			System.out.println("negative");
		}
		int[] data = new int[len];

		for(int i = 0; i < len; i++) {
			data[i] = vpeek(x+i, y);
		}
		return data;
	}
	/**
	 * 1s̃f[^ԂD
	 * @param y YW
	 * @return 1s̃f[^
	 */
	public int[] vpeek(int y) {
		return (int[])map.get(y);
	}
	/**
	 * DxrD
	 * @param arg0 rΏ
	 * @return 0: 1: -1:Ⴂ
	 */
	public int compareTo(Object arg0) {
		Plane buddy = (Plane)arg0;
		if(buddy.getPriority() == getPriority()) {
			return 0;
		}
		return buddy.getPriority() < getPriority() ? 1 : -1;
	}
	/**
	 * eLXgʂ1sXN[D
	 * SĂ̍sdirty flagݒ肳D
	 * @param mode true:key on / false:key off
	 */
	public void scrollUp(boolean mode) {
		// 擪s̍폜ƍŏIs̒ǉ
		map.remove(0);
		if(mode == false) {
			// ŉiɑ΂čsǉ
			map.add(new int[width]);
		} else {
			// ŉi1̍sɑ΂čsǉ
			map.add(map.size()-1, new int[width]);
		}
		// SĂ̍sdirty flagݒ肷
		dirty = true;
		for(int i = 0; i < dirtymap.length; i++) {
			dirtymap[i] = true;
		}
	}
	/**
	 * eLXgʂ1sXN[D
	 * @param y YW(̍s艺̑SĂ̍s1i)
	 * @param mode true:key on / false:key off
	 */
	public void scrollDown(int y, boolean mode) {
		// sǉ
		map.insertElementAt(new int[width], y);

		// 擪s̍폜ƍŏIs̒ǉ
		map.remove(map.size()-1-(mode ? 1 : 0));

		// }sȉdirtytOSĐݒ
		dirty = true;
		for(int i = y; i < dirtymap.length; i++) {
			dirtymap[i] = true;
		}
	}
	/**
	 * D
	 */
	public void clear() {
		map = new Vector();
		for(int i = 0; i < height; i++) {
			map.add(new int[width]);
		}
		dirtymap = new boolean[height];
		dirty = true;
		bitmap = new BufferedImage(fd.getFontWidth() * width, fd.getFontHeight() * height, BufferedImage.TYPE_INT_ARGB);
	}
	/**
	 * ĕ`悷.
	 *
	 */
	public void refresh() {
		dirtymap = new boolean[height];
		for(int i = 0; i < dirtymap.length; i++) {
			dirtymap[i] = true;
		}
		dirty = true;
	}
	/**
	 * VRAMzʏɕ`悷邩ǂݒ肷D
	 * @param b true: \Ώ / false: \
	 */
	public void setEnable(boolean b) {
		enabled = b;
	}
	/**
	 * VRAMzʏɕ`悳邩ǂԂD
	 * @return true: \Ώ / false: \
	 */
	public boolean isEnable() {
		return enabled;
	}
}
