<?php
/**
 * function globalUtils
 *
 * PHP versions 4 and 5
 *
 * @author     Shiro Tajima <tajima@exbridge.jp>
 * @copyright  2007 Exbridge,inc.
 * @version    1.0
 */

/**
 * 概要
 *  UTF-8へのエンコード
 */
function enc_utf8($val) {
    return mb_convert_encoding( $val, "UTF-8", PW_ENCODE );
}

/**
 * 概要
 *  WEB層の文字コードへのデコード
 */
function dec_utf8($val) {
    return mb_convert_encoding( $value, PW_ENCODE, "UTF-8" );
}

/**
 * 同期関数
 *
 * @return obj
 */
function synchronize($params1, $params2) {
    if (is_null($params1)) {
        trigger_error("synchronize params1 is null.", E_USER_NOTICE);
        return;
    }
    if (is_null($params2)) {
        trigger_error("synchronize params2 is null.", E_USER_NOTICE);
        return;
    }

    if (is_array($params1) || is_object($params1) || is_array($params2) || is_object($params2)) {
        foreach ($params2 as $key => $val) {
            if (is_object($val)) {
                $params1->$key =& $val;
            }
            else {
                $params1->$key = $val;
            }
        }
    }
}

/**
 * text + select タグヘルパー
 * 
 * @param $nm   id,name
 * @param $val  value
 * @param $vals list
 * @param $ev   event
 */
function text_select_tag($nm, $val, $vals, $size, $ev=null, $ev2=null) {
    $hidden = input_hidden_tag($nm, $val);
    $input  = input_a_tag($nm.'_t' , $val, array('size'=>$size, 'onChange'=>"Javascript:setIdToListBox(this, '" . $nm . "_s');document.getElementById('" . $nm . "').value=this.value;" . $ev, 'disabled'=>$ev2));
    $select = select_tag($nm.'_s', options_for_select($vals, $val), array('onChange'=>"Javascript:setIdToText(this, '" . $nm . "_t');document.getElementById('" . $nm . "').value=this.value;" . $ev . "",'onFocus'=>"Javascript:setIdToText(this, '" . $nm . "_t');document.getElementById('" . $nm . "').value=this.value;", 'disabled'=>$ev2));
    return "<table border=0 cellpadding=0 cellspacing=0><tr><td>" . $input . "</td><td>" . $select . "</td><td>" . $hidden . "</td></table>";
}

function xb_year_select_tag($name, $options = array (), $default_value = null, $nullCol = false, $minYear = null, $maxYear = null) {
    $year = array ();

    $y = date('Y');

    //引数取得
    $min = $minYear;
    $max = $maxYear;

    if (is_null($minYear)) {
        $min = MIN_DISP_YEAR;
    }
    if (is_null($maxYear)) {
        $max = MAX_DISP_YEAR;
    }
    if ($nullCol) {
        $year[''] = null;
    }
    if (!isset ($default_value) || $default_value == '') {
        if ($nullCol) {
            $default_value = '';
        } else {
            $default_value = $y;
        }
    }

    for ($i = $y - $min; $i <= $y + $max; $i++) {
        $year[$i] = $i;
    }
    return select_tag($name, options_for_select($year, $default_value), $options);
}

function xb_month_select_tag($name, $options = array (), $default_value = null, $nullCol = false) {
    $m = date('m');
    $month = array ();
    //20060715 Y.shimizu 1行追加
    if ($nullCol) {
        $month[''] = null;
    }
    for ($i = 1; $i < 13; $i++) {
        $tmpMonth = LPAD($i, 2);
        $month[$tmpMonth] = $tmpMonth;
    }
    if (!isset ($default_value) || $default_value == '') {
        if ($nullCol) {
            $default_value = '';
        } else {
            $default_value = $m;
        }
    }
    return select_tag($name, options_for_select($month, $default_value), $options);
}

function xb_day_select_tag($name, $options = array (), $default_value = null, $nullCol = false, $simbiFlag = false) {
    $day = array ();
    //20060715 Y.shimizu 1行追加
    if ($nullCol) {
        $day[''] = null;
    }
    for ($i = 1; $i < 32; $i++) {
        $tmpDay = LPAD($i, 2);
        $day[$tmpDay] = $tmpDay;
    }
    if (true == $simbiFlag) {
        $day["99"] = "99";
    }
    if (!isset ($default_value) || $default_value == '') {
        if ($nullCol) {
            $default_value = '';
        } else {
            $d = date('d');
            $default_value = $d;
        }
    }
    return select_tag($name, options_for_select($day, $default_value), $options);
}

/**
 * コード情報リストの取得
 *
 * Auroraのwebサービスを利用してカテゴリーリストを取得します
 *
 * @access public
 * @return array
 */
function get_code_list($code_kb) {
    //コードリスト取得
    $requestUrl = AURORA_URL . 'xbeWebMaster.php?action=RequestCodeList' . '&code_kb=' . $code_kb . '&magic=' . AUTH_MAGIC;
    $data = get_url_contents($requestUrl);
    debugLog(__METHOD__ . 'requestURL' . $requestUrl, __CLASS__, __FILE__, __LINE__);
    return json_decode($data, true);
}

/**
 * getTimestamp:タイムスタンプ取得
 *
 * @return: true:false
 * @access: private.
 */
function getTimestamp($value=null){
    if(is_null($value)){
        $value = time();
    }
    return date("Y-m-d H:i:s", $value);
}


?>
