<?php
/**
 * function writeDate
 *
 * PHP versions 4 and 5
 *
 * @author     Shiro Tajima <tajima@exbridge.jp>
 * @copyright  2007 Exbridge,inc.
 * @version    1.0
 */

/**
 * writeWindowTitle
 *
 * 機能
 *  ウィンドウタイトル表示用のライター
 *
 * @param $number
 * @param $number
 *
 */
function writeWindowTitle ($function_name, $display_name) {
    return SYSTEM_PRODUCT . " Ver.".VERSION." : ".$function_name . " - ".$display_name;
}

/**
 * writeMoney
 *
 * 機能
 *  表示用のライター
 *
 * @param $number
 * @param $decimals 少数桁
 * @return string
 */
function writeMoney( $number, $decimals=0, $null_val=null){
    if(isNULL($number)){
        return $null_val;
    }
    else{
        return number_format( $number, $decimals );
    }
}

/**
 * writeDate
 *
 *  8桁数字文字列を日付フォーマットへ変換する
 *
 * @access  なし
 * @param  $str 8桁数字文字列
 * @return なし
 * @see    なし
 */
function writeDate( $str ){
    if( $str == '-' || isNULL($str)){
        return '-';
    }
    $str = str_replace(array('/','-'), '', $str);
    $str = substr($str,0 ,8);
    return substr($str, 0, 4 )."/".substr($str, 4, 2)."/".substr($str, 6, 2);
}

function writeDateJp( $str ){
    if( $str == '-' || isNULL($str)){
        return '-';
    }
    $str = str_replace(array('/','-'), '', $str);
    $str = substr($str,0 ,8);
    return substr($str, 0, 4 )."年".substr($str, 4, 2)."月".substr($str, 6, 2)."日";
}



/**
 * 日付フォーマット（YYYYMMDDHHmmss→YYYY-MM-DD HH:mm:SS （Ex.2007-11-08 15:15:05））
 *
 * @param $val  yyyymmddhhmmss
 */
function formatYmdHmsWriter($val){
    if(!isNULL($val)){
        $year   = substr($val,0,4);
        $month  = substr($val,4,2);
        $day    = substr($val,6,2);
        $hour   = substr($val,8,2);
        $minute = substr($val,10,2);
        $second = substr($val,12,2);

        return  $year."-".$month."-".$day." ".$hour.":".$minute.":".$second;
    }
    else{
        return $val;
    }
}

/**
 * 日付アンフォーマット（YYYY-MM-DD HH:mm:SS →YYYYMMDDHHmmSS）
 *
 * @param $val  yyyymmddhhmmss
 */
function unFormatYmdHmsWriter($val){
    if(!isNULL($val)){
        return str_replace(array('-',':',' '), array('','',''), $val);
    }
    else{
        return $val;
    }
}

?>