<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    xbpwCredential.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwSecurityUser.php 527 2008-06-05 00:50:27Z tajima $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwSecurityUser
{
    /** 認証用 */
    var $authenticated = false;

    /** 権限用 */
    var $credentials = array();

    /** ユーザーパラメータ */
    var $userParameter = array();

    /**
     * isAuthenticated method.
     * @access public
     */
    function isAuthenticated()
    {
        return $this->authenticated;
    }

    /**
     * setAuthenticated method.
     * @access public
     */
    function setAuthenticated($boolean)
    {
        $this->authenticated = $boolean;
        if (!$boolean) {
            $this->clearSecurityUser();
        }
    }

    /**
     * addCredential method.
     * @access public
     */
    function addCredential($val)
    {
        $this->credentials[$val] = $val;
    }

    /**
     * isCredential method.
     * @access public
     */
    function isCredential($val)
    {
        if (isset($this->credentials[$val]) || !is_null($this->credentials[$val]) || $this->credentials[$val]!='') {
            return true;
        }
        else {
            return false;
        }
    }

    /**
     * addCredential method.
     * @access public
     */
    function clearSecurityUser()
    {
        $this->authenticated = false;
        $this->credentials = array();
        $this->userParameter = array();
    }

    /**
     * setParameter method.
     * @access public
     */
    function setUserParameter($key, $val)
    {
        $this->userParameter[$key] = $val;
    }

    /**
     * getParameter method.
     * @access public
     */
    function getUserParameter($key)
    {
        return $this->userParameter[$key];
    }
}
